/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmMatchEntrySerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6ExthdrCase;

public class OxmIpv6ExtHdrSerializer
extends AbstractOxmMatchEntrySerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        Ipv6ExthdrCase entryValue = (Ipv6ExthdrCase)entry.getMatchEntryValue();
        Ipv6ExthdrFlags pseudoField = entryValue.getIpv6Exthdr().getPseudoField();
        int bitmap = ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{pseudoField.isNonext(), pseudoField.isEsp(), pseudoField.isAuth(), pseudoField.isDest(), pseudoField.isFrag(), pseudoField.isRouter(), pseudoField.isHop(), pseudoField.isUnrep(), pseudoField.isUnseq()});
        outBuffer.writeShort(bitmap);
        if (entry.isHasMask().booleanValue()) {
            outBuffer.writeBytes(entryValue.getIpv6Exthdr().getMask());
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 39;
    }

    @Override
    protected int getValueLength() {
        return 2;
    }
}

