/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmMatchEntrySerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6FlabelCase;

public class OxmIpv6FlabelSerializer
extends AbstractOxmMatchEntrySerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        Ipv6FlabelCase entryValue = (Ipv6FlabelCase)entry.getMatchEntryValue();
        outBuffer.writeInt(entryValue.getIpv6Flabel().getIpv6Flabel().getValue().intValue());
        if (entry.isHasMask().booleanValue()) {
            OxmIpv6FlabelSerializer.writeMask(entryValue.getIpv6Flabel().getMask(), outBuffer, 4);
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 28;
    }

    @Override
    protected int getValueLength() {
        return 4;
    }
}

