/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmMatchEntrySerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.PbbIsidCase;

public class OxmPbbIsidSerializer
extends AbstractOxmMatchEntrySerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        PbbIsidCase entryValue = (PbbIsidCase)entry.getMatchEntryValue();
        outBuffer.writeMedium(entryValue.getPbbIsid().getIsid().intValue());
        if (entry.isHasMask().booleanValue()) {
            OxmPbbIsidSerializer.writeMask(entryValue.getPbbIsid().getMask(), outBuffer, this.getValueLength());
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 37;
    }

    @Override
    protected int getValueLength() {
        return 3;
    }
}

