/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmMatchEntrySerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.TunnelIdCase;

public class OxmTunnelIdSerializer
extends AbstractOxmMatchEntrySerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        TunnelIdCase entryValue = (TunnelIdCase)entry.getMatchEntryValue();
        outBuffer.writeBytes(entryValue.getTunnelId().getTunnelId());
        if (entry.isHasMask().booleanValue()) {
            OxmTunnelIdSerializer.writeMask(entryValue.getTunnelId().getMask(), outBuffer, 8);
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 38;
    }

    @Override
    protected int getValueLength() {
        return 8;
    }
}

