/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmMatchEntrySerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.VlanVidCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.vlan.vid._case.VlanVid;

public class OxmVlanVidSerializer
extends AbstractOxmMatchEntrySerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        VlanVid vlanVid = ((VlanVidCase)entry.getMatchEntryValue()).getVlanVid();
        int vlanVidValue = vlanVid.getVlanVid();
        if (vlanVid.isCfiBit().booleanValue()) {
            int cfi = 4096;
            vlanVidValue |= cfi;
        }
        outBuffer.writeShort(vlanVidValue);
        if (entry.isHasMask().booleanValue()) {
            OxmVlanVidSerializer.writeMask(vlanVid.getMask(), outBuffer, this.getValueLength());
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 6;
    }

    @Override
    protected int getValueLength() {
        return 2;
    }
}

