/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.keys.ActionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterActionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterInstructionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.InstructionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.util.AbstractCodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;

public abstract class CodeKeyMakerFactory {
    private CodeKeyMakerFactory() {
    }

    public static CodeKeyMaker createMatchEntriesKeyMaker(short version) {
        return new AbstractCodeKeyMaker(version){

            @Override
            public MessageCodeKey make(ByteBuf input) {
                int oxmClass = input.getUnsignedShort(input.readerIndex());
                int oxmField = input.getUnsignedByte(input.readerIndex() + 2) >>> 1;
                MatchEntryDeserializerKey key = new MatchEntryDeserializerKey(this.getVersion(), oxmClass, oxmField);
                if (oxmClass == 65535) {
                    long expId = input.getUnsignedInt(input.readerIndex() + 2 + 2);
                    key.setExperimenterId(Long.valueOf(expId));
                    return key;
                }
                key.setExperimenterId(null);
                return key;
            }
        };
    }

    public static CodeKeyMaker createActionsKeyMaker(short version) {
        return new AbstractCodeKeyMaker(version){

            @Override
            public MessageCodeKey make(ByteBuf input) {
                int type = input.getUnsignedShort(input.readerIndex());
                if (type == 65535) {
                    Long expId = input.getUnsignedInt(input.readerIndex() + 4);
                    return new ExperimenterActionDeserializerKey(this.getVersion(), expId);
                }
                ActionDeserializerKey actionDeserializerKey = new ActionDeserializerKey(this.getVersion(), type, null);
                return actionDeserializerKey;
            }
        };
    }

    public static CodeKeyMaker createInstructionsKeyMaker(short version) {
        return new AbstractCodeKeyMaker(version){

            @Override
            public MessageCodeKey make(ByteBuf input) {
                int type = input.getUnsignedShort(input.readerIndex());
                if (type == 65535) {
                    Long expId = input.getUnsignedInt(input.readerIndex() + 4);
                    return new ExperimenterInstructionDeserializerKey(this.getVersion(), expId);
                }
                return new InstructionDeserializerKey(this.getVersion(), type, null);
            }
        };
    }
}

