/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.HeaderDeserializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(ListDeserializer.class);

    private ListDeserializer() {
        throw new UnsupportedOperationException("Utility class shouldn't be instantiated");
    }

    public static <E extends DataObject> List<E> deserializeList(short version, int length, ByteBuf input, CodeKeyMaker keyMaker, DeserializerRegistry registry) {
        ArrayList<DataObject> items = null;
        if (input.readableBytes() > 0) {
            items = new ArrayList<DataObject>();
            int startIndex = input.readerIndex();
            while (input.readerIndex() - startIndex < length) {
                OFDeserializer deserializer = (OFDeserializer)registry.getDeserializer(keyMaker.make(input));
                DataObject item = (DataObject)deserializer.deserialize(input);
                items.add(item);
            }
        }
        return items;
    }

    public static <E extends DataObject> List<E> deserializeHeaders(short version, int length, ByteBuf input, CodeKeyMaker keyMaker, DeserializerRegistry registry) {
        ArrayList<DataObject> items = null;
        if (input.readableBytes() > 0) {
            items = new ArrayList<DataObject>();
            int startIndex = input.readerIndex();
            boolean exceptionLogged = false;
            while (input.readerIndex() - startIndex < length) {
                HeaderDeserializer deserializer;
                MessageCodeKey key = keyMaker.make(input);
                try {
                    deserializer = (HeaderDeserializer)registry.getDeserializer(key);
                }
                catch (ClassCastException | IllegalStateException e) {
                    if (!exceptionLogged) {
                        LOG.warn("Problem during reading table feature property. Skipping unknown feature property: {}.If more information is needed, set org.opendaylight.openflowjava do DEBUG log level.", (Object)key, (Object)e.getMessage());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Detailed exception: {}", (Throwable)e);
                            LOG.debug("This exception is logged only once for each multipart reply (table features) to prevent log flooding. There might be more of table features related exceptions.");
                        }
                        exceptionLogged = true;
                    }
                    input.skipBytes(4);
                    continue;
                }
                DataObject item = deserializer.deserializeHeader(input);
                items.add(item);
            }
        }
        return items;
    }
}

