/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.HeaderSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;

public abstract class ListSerializer {
    private ListSerializer() {
    }

    public static <E extends DataObject> void serializeList(List<E> list, TypeKeyMaker<E> keyMaker, SerializerRegistry registry, ByteBuf outBuffer) {
        if (list != null) {
            for (DataObject item : list) {
                OFSerializer serializer = (OFSerializer)registry.getSerializer(keyMaker.make(item));
                serializer.serialize((DataContainer)item, outBuffer);
            }
        }
    }

    public static <E extends DataObject> void serializeHeaderList(List<E> list, TypeKeyMaker<E> keyMaker, SerializerRegistry registry, ByteBuf outBuffer) {
        if (list != null) {
            for (DataObject item : list) {
                HeaderSerializer serializer = (HeaderSerializer)registry.getSerializer(keyMaker.make(item));
                serializer.serializeHeader(item, outBuffer);
            }
        }
    }
}

