/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.StandardMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.MatchBuilder;

public class MatchDeserializer
implements OFDeserializer<Match>,
DeserializerRegistryInjector {
    private DeserializerRegistry registry;

    public Match deserialize(ByteBuf input) {
        if (input.readableBytes() > 0) {
            MatchBuilder builder = new MatchBuilder();
            int type = input.readUnsignedShort();
            int length = input.readUnsignedShort();
            switch (type) {
                case 0: {
                    builder.setType(StandardMatchType.class);
                    break;
                }
                case 1: {
                    builder.setType(OxmMatchType.class);
                    break;
                }
            }
            CodeKeyMaker keyMaker = CodeKeyMakerFactory.createMatchEntriesKeyMaker((short)4);
            List entries = ListDeserializer.deserializeList((short)4, length - 4, input, keyMaker, this.registry);
            builder.setMatchEntry(entries);
            int paddingRemainder = length % 8;
            if (paddingRemainder != 0) {
                input.skipBytes(8 - paddingRemainder);
            }
            return builder.build();
        }
        return null;
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }
}

