/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10Builder;

public class OF10MatchDeserializer
implements OFDeserializer<MatchV10> {
    private static final byte PADDING_IN_MATCH = 1;
    private static final byte PADDING_IN_MATCH_2 = 2;
    private static final byte NW_SRC_BITS = 6;
    private static final byte NW_SRC_SHIFT = 8;
    private static final int NW_SRC_MASK = 16128;
    private static final byte NW_DST_BITS = 6;
    private static final byte NW_DST_SHIFT = 14;
    private static final int NW_DST_MASK = 1032192;

    public MatchV10 deserialize(ByteBuf input) {
        MatchV10Builder builder = new MatchV10Builder();
        long wildcards = input.readUnsignedInt();
        builder.setWildcards(OF10MatchDeserializer.createWildcards(wildcards));
        builder.setNwSrcMask(Short.valueOf(OF10MatchDeserializer.decodeNwSrcMask(wildcards)));
        builder.setNwDstMask(Short.valueOf(OF10MatchDeserializer.decodeNwDstMask(wildcards)));
        builder.setInPort(Integer.valueOf(input.readUnsignedShort()));
        byte[] dlSrc = new byte[6];
        input.readBytes(dlSrc);
        builder.setDlSrc(new MacAddress(ByteBufUtils.macAddressToString((byte[])dlSrc)));
        byte[] dlDst = new byte[6];
        input.readBytes(dlDst);
        builder.setDlDst(new MacAddress(ByteBufUtils.macAddressToString((byte[])dlDst)));
        builder.setDlVlan(Integer.valueOf(input.readUnsignedShort()));
        builder.setDlVlanPcp(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(1);
        builder.setDlType(Integer.valueOf(input.readUnsignedShort()));
        builder.setNwTos(Short.valueOf(input.readUnsignedByte()));
        builder.setNwProto(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(2);
        builder.setNwSrc(new Ipv4Address(ByteBufUtils.readIpv4Address((ByteBuf)input)));
        builder.setNwDst(new Ipv4Address(ByteBufUtils.readIpv4Address((ByteBuf)input)));
        builder.setTpSrc(Integer.valueOf(input.readUnsignedShort()));
        builder.setTpDst(Integer.valueOf(input.readUnsignedShort()));
        return builder.build();
    }

    public static FlowWildcardsV10 createWildcards(long input) {
        boolean inPort = (input & 1L) != 0L;
        boolean dlVLAN = (input & 2L) != 0L;
        boolean dlSrc = (input & 4L) != 0L;
        boolean dlDst = (input & 8L) != 0L;
        boolean dLType = (input & 0x10L) != 0L;
        boolean nwProto = (input & 0x20L) != 0L;
        boolean tpSrc = (input & 0x40L) != 0L;
        boolean tpDst = (input & 0x80L) != 0L;
        boolean dlVLANpcp = (input & 0x100000L) != 0L;
        boolean nwTos = (input & 0x200000L) != 0L;
        return new FlowWildcardsV10(Boolean.valueOf(dlDst), Boolean.valueOf(dlSrc), Boolean.valueOf(dLType), Boolean.valueOf(dlVLAN), Boolean.valueOf(dlVLANpcp), Boolean.valueOf(inPort), Boolean.valueOf(nwProto), Boolean.valueOf(nwTos), Boolean.valueOf(tpDst), Boolean.valueOf(tpSrc));
    }

    public static short decodeNwSrcMask(long input) {
        return (short)Math.max(32L - ((input & 0x3F00L) >> 8), 0L);
    }

    public static short decodeNwDstMask(long input) {
        return (short)Math.max(32L - ((input & 0xFC000L) >> 14), 0L);
    }
}

