/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;

public class OF10MatchSerializer
implements OFSerializer<MatchV10> {
    private static final byte PADDING_IN_MATCH = 1;
    private static final byte PADDING_IN_MATCH_2 = 2;
    private static final byte NW_SRC_SHIFT = 8;
    private static final byte NW_DST_SHIFT = 14;

    public void serialize(MatchV10 match, ByteBuf outBuffer) {
        outBuffer.writeInt(OF10MatchSerializer.encodeWildcards(match.getWildcards(), match.getNwSrcMask(), match.getNwDstMask()));
        outBuffer.writeShort(match.getInPort().intValue());
        outBuffer.writeBytes(ByteBufUtils.macAddressToBytes((String)match.getDlSrc().getValue()));
        outBuffer.writeBytes(ByteBufUtils.macAddressToBytes((String)match.getDlDst().getValue()));
        outBuffer.writeShort(match.getDlVlan().intValue());
        outBuffer.writeByte((int)match.getDlVlanPcp().shortValue());
        outBuffer.writeZero(1);
        outBuffer.writeShort(match.getDlType().intValue());
        outBuffer.writeByte((int)match.getNwTos().shortValue());
        outBuffer.writeByte((int)match.getNwProto().shortValue());
        outBuffer.writeZero(2);
        Iterable srcGroups = ByteBufUtils.DOT_SPLITTER.split((CharSequence)match.getNwSrc().getValue());
        for (String group : srcGroups) {
            outBuffer.writeByte((int)Short.parseShort(group));
        }
        Iterable dstGroups = ByteBufUtils.DOT_SPLITTER.split((CharSequence)match.getNwDst().getValue());
        for (String group : dstGroups) {
            outBuffer.writeByte((int)Short.parseShort(group));
        }
        outBuffer.writeShort(match.getTpSrc().intValue());
        outBuffer.writeShort(match.getTpDst().intValue());
    }

    private static int encodeWildcards(FlowWildcardsV10 wildcards, short srcMask, short dstMask) {
        int bitmask = ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{wildcards.isINPORT(), wildcards.isDLVLAN(), wildcards.isDLSRC(), wildcards.isDLDST(), wildcards.isDLTYPE(), wildcards.isNWPROTO(), wildcards.isTPSRC(), wildcards.isTPDST()});
        bitmask |= ByteBufUtils.fillBitMask((int)20, (boolean[])new boolean[]{wildcards.isDLVLANPCP(), wildcards.isNWTOS()});
        bitmask |= 32 - srcMask << 8;
        return bitmask |= 32 - dstMask << 14;
    }
}

