/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.ExperimenterIdCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.StandardMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ExperimenterClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OF13MatchSerializer
implements OFSerializer<Match>,
SerializerRegistryInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OF13MatchSerializer.class);
    private static final byte STANDARD_MATCH_TYPE_CODE = 0;
    private static final byte OXM_MATCH_TYPE_CODE = 1;
    private SerializerRegistry registry;

    public void serialize(Match match, ByteBuf outBuffer) {
        if (match == null) {
            LOGGER.debug("Match is null");
            return;
        }
        int matchStartIndex = outBuffer.writerIndex();
        OF13MatchSerializer.serializeType(match, outBuffer);
        int matchLengthIndex = outBuffer.writerIndex();
        outBuffer.writeShort(0);
        this.serializeMatchEntries(match.getMatchEntry(), outBuffer);
        int matchLength = outBuffer.writerIndex() - matchStartIndex;
        outBuffer.setShort(matchLengthIndex, matchLength);
        int paddingRemainder = matchLength % 8;
        if (paddingRemainder != 0) {
            outBuffer.writeZero(8 - paddingRemainder);
        }
    }

    private static void serializeType(Match match, ByteBuf out) {
        if (match.getType().isAssignableFrom(StandardMatchType.class)) {
            out.writeShort(0);
        } else if (match.getType().isAssignableFrom(OxmMatchType.class)) {
            out.writeShort(1);
        }
    }

    public void serializeMatchEntries(List<MatchEntry> matchEntries, ByteBuf out) {
        if (matchEntries == null) {
            LOGGER.debug("Match entries are null");
            return;
        }
        for (MatchEntry entry : matchEntries) {
            MatchEntrySerializerKey key = new MatchEntrySerializerKey(4, entry.getOxmClass(), entry.getOxmMatchField());
            if (entry.getOxmClass().equals(ExperimenterClass.class)) {
                ExperimenterIdCase entryValue = (ExperimenterIdCase)entry.getMatchEntryValue();
                key.setExperimenterId(entryValue.getExperimenter().getExperimenter().getValue());
            } else {
                key.setExperimenterId(null);
            }
            OFSerializer entrySerializer = (OFSerializer)this.registry.getSerializer((MessageTypeKey)key);
            entrySerializer.serialize((DataContainer)entry, out);
        }
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

