/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;

public abstract class OpenflowUtils {
    private OpenflowUtils() {
    }

    public static PortStateV10 createPortState(long input) {
        Boolean psLinkDown = (input & 1L) != 0L;
        Boolean psBlocked = (input & 2L) != 0L;
        Boolean psLive = (input & 4L) != 0L;
        Boolean psStpListen = (input & 0x100L) == 0L;
        Boolean psStpLearn = (input & 0x100L) != 0L;
        Boolean psStpForward = (input & 0x200L) != 0L;
        Boolean psStpBlock = (input & 0x200L) != 0L && (input & 0x100L) != 0L;
        Boolean psStpMask = (input & 0x400L) != 0L;
        return new PortStateV10(psBlocked, psLinkDown, psLive, psStpBlock, psStpForward, psStpLearn, psStpListen, psStpMask);
    }

    public static PortConfigV10 createPortConfig(long input) {
        Boolean pcPortDown = (input & 1L) != 0L;
        Boolean pcNoStp = (input & 2L) != 0L;
        Boolean pcNoRecv = (input & 4L) != 0L;
        Boolean pcNoRecvStp = (input & 8L) != 0L;
        Boolean pcNoFlood = (input & 0x10L) != 0L;
        Boolean pcNoFwd = (input & 0x20L) != 0L;
        Boolean pcNoPacketIn = (input & 0x40L) != 0L;
        return new PortConfigV10(pcNoFlood, pcNoFwd, pcNoPacketIn, pcNoRecv, pcNoRecvStp, pcNoStp, pcPortDown);
    }

    public static PortFeaturesV10 createPortFeatures(long input) {
        Boolean pf10mbHd = (input & 1L) != 0L;
        Boolean pf10mbFd = (input & 2L) != 0L;
        Boolean pf100mbHd = (input & 4L) != 0L;
        Boolean pf100mbFd = (input & 8L) != 0L;
        Boolean pf1gbHd = (input & 0x10L) != 0L;
        Boolean pf1gbFd = (input & 0x20L) != 0L;
        Boolean pf10gbFd = (input & 0x40L) != 0L;
        Boolean pfCopper = (input & 0x80L) != 0L;
        Boolean pfFiber = (input & 0x100L) != 0L;
        Boolean pfAutoneg = (input & 0x200L) != 0L;
        Boolean pfPause = (input & 0x400L) != 0L;
        Boolean pfPauseAsym = (input & 0x800L) != 0L;
        return new PortFeaturesV10(pf100mbFd, pf100mbHd, pf10gbFd, pf10mbFd, pf10mbHd, pf1gbFd, pf1gbHd, pfAutoneg, pfCopper, pfFiber, pfPause, pfPauseAsym);
    }
}

