/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import org.opendaylight.openflowjava.protocol.api.keys.ActionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.InstructionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.util.AbstractTypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.ExperimenterIdCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ExperimenterClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;

public abstract class TypeKeyMakerFactory {
    private TypeKeyMakerFactory() {
    }

    public static TypeKeyMaker<MatchEntry> createMatchEntriesKeyMaker(short version) {
        return new AbstractTypeKeyMaker<MatchEntry>(version){

            public MatchEntrySerializerKey<?, ?> make(MatchEntry entry) {
                MatchEntrySerializerKey key = new MatchEntrySerializerKey(this.getVersion(), entry.getOxmClass(), entry.getOxmMatchField());
                if (entry.getOxmClass().equals(ExperimenterClass.class)) {
                    ExperimenterIdCase entryValue = (ExperimenterIdCase)entry.getMatchEntryValue();
                    key.setExperimenterId(entryValue.getExperimenter().getExperimenter().getValue());
                    return key;
                }
                key.setExperimenterId(null);
                return key;
            }
        };
    }

    public static TypeKeyMaker<Action> createActionKeyMaker(short version) {
        return new AbstractTypeKeyMaker<Action>(version){

            @Override
            public MessageTypeKey<?> make(Action entry) {
                if (entry.getExperimenterId() != null) {
                    return new ActionSerializerKey(this.getVersion(), entry.getActionChoice().getImplementedInterface(), entry.getExperimenterId().getValue());
                }
                return new ActionSerializerKey(this.getVersion(), entry.getActionChoice().getImplementedInterface(), null);
            }
        };
    }

    public static TypeKeyMaker<Instruction> createInstructionKeyMaker(short version) {
        return new AbstractTypeKeyMaker<Instruction>(version){

            @Override
            public MessageTypeKey<?> make(Instruction entry) {
                if (entry.getExperimenterId() != null) {
                    return new InstructionSerializerKey(this.getVersion(), entry.getInstructionChoice().getImplementedInterface(), entry.getExperimenterId().getValue());
                }
                return new InstructionSerializerKey(this.getVersion(), entry.getInstructionChoice().getImplementedInterface(), null);
            }
        };
    }
}

