/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.statistics;

import java.util.concurrent.atomic.AtomicLong;

public class Counter {
    private AtomicLong counterValue = new AtomicLong(0L);
    private AtomicLong counterLastReadValue = new AtomicLong(0L);

    public void incrementCounter() {
        this.counterValue.incrementAndGet();
    }

    public long getCounterLastReadValue() {
        return this.counterLastReadValue.get();
    }

    public long getCounterValue() {
        return this.getCounterValue(true);
    }

    public long getCounterValue(boolean modifyLastReadValue) {
        if (modifyLastReadValue) {
            this.counterLastReadValue.set(this.counterValue.get());
        }
        return this.counterValue.get();
    }

    public void reset() {
        this.counterValue.set(0L);
        this.counterLastReadValue.set(0L);
    }

    public String getStat() {
        long cntPrevVal = this.getCounterLastReadValue();
        long cntCurValue = this.getCounterValue();
        return String.format("+%d | %d", cntCurValue - cntPrevVal, cntCurValue);
    }
}

