/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.statistics;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.openflowjava.protocol.spi.statistics.StatisticsHandler;
import org.opendaylight.openflowjava.statistics.Counter;
import org.opendaylight.openflowjava.statistics.CounterEventTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatisticsCounters
implements StatisticsHandler {
    public static final int DEFAULT_LOG_REPORT_PERIOD = 10000;
    public static final int MINIMAL_LOG_REPORT_PERIOD = 500;
    private static StatisticsCounters instanceHolder;
    private static final Logger LOGGER;
    private Timer logReporter;
    private int logReportPeriod;
    private boolean runLogReport;
    private Map<CounterEventTypes, Counter> countersMap;
    private boolean runCounting;
    private CounterEventTypes[] enabledCounters = new CounterEventTypes[]{CounterEventTypes.DS_ENCODE_FAIL, CounterEventTypes.DS_ENCODE_SUCCESS, CounterEventTypes.DS_ENTERED_OFJAVA, CounterEventTypes.DS_FLOW_MODS_ENTERED, CounterEventTypes.DS_FLOW_MODS_SENT, CounterEventTypes.US_DROPPED_PACKET_IN, CounterEventTypes.US_DECODE_FAIL, CounterEventTypes.US_DECODE_SUCCESS, CounterEventTypes.US_MESSAGE_PASS, CounterEventTypes.US_RECEIVED_IN_OFJAVA};

    public static synchronized StatisticsCounters getInstance() {
        if (instanceHolder == null) {
            instanceHolder = new StatisticsCounters();
        }
        return instanceHolder;
    }

    private StatisticsCounters() {
        this.countersMap = new ConcurrentHashMap<CounterEventTypes, Counter>();
        for (CounterEventTypes cet : this.enabledCounters) {
            this.countersMap.put(cet, new Counter());
        }
        this.runCounting = false;
        this.logReportPeriod = 0;
        this.runLogReport = false;
        LOGGER.debug("StaticsCounters has been created");
    }

    public void startCounting(boolean reportToLogs, int logReportDelay) {
        if (this.runCounting) {
            return;
        }
        this.resetCounters();
        LOGGER.debug("Counting started...");
        if (reportToLogs) {
            this.startLogReport(logReportDelay);
        }
        this.runCounting = true;
    }

    public void stopCounting() {
        this.runCounting = false;
        LOGGER.debug("Stop counting...");
        this.stopLogReport();
    }

    public boolean isRunCounting() {
        return this.runCounting;
    }

    public void startLogReport(int logReportDelay) {
        if (this.runLogReport) {
            return;
        }
        if (logReportDelay <= 0) {
            throw new IllegalArgumentException("logReportDelay has to be greater than 0");
        }
        this.logReportPeriod = logReportDelay < 500 ? 500 : logReportDelay;
        this.logReporter = new Timer("SC_Timer");
        this.logReporter.schedule((TimerTask)new LogReporterTask(this), this.logReportPeriod, (long)this.logReportPeriod);
        this.runLogReport = true;
        LOGGER.debug("Statistics log reporter has been scheduled with period {} ms", (Object)this.logReportPeriod);
    }

    public void stopLogReport() {
        if (this.runLogReport) {
            if (this.logReporter != null) {
                this.logReporter.cancel();
                LOGGER.debug("Statistics log reporter has been canceled");
            }
            this.runLogReport = false;
        }
    }

    public boolean isRunLogReport() {
        return this.runLogReport;
    }

    public int getLogReportPeriod() {
        return this.logReportPeriod;
    }

    protected CounterEventTypes[] getEnabledCounters() {
        return this.enabledCounters;
    }

    protected Map<CounterEventTypes, Counter> getCountersMap() {
        return this.countersMap;
    }

    public boolean isCounterEnabled(CounterEventTypes counterEventKey) {
        if (counterEventKey == null) {
            return false;
        }
        return this.countersMap.containsKey((Object)counterEventKey);
    }

    public Counter getCounter(CounterEventTypes counterEventKey) {
        if (counterEventKey == null) {
            throw new IllegalArgumentException("counterEventKey can not be null");
        }
        return this.countersMap.get((Object)counterEventKey);
    }

    public void incrementCounter(CounterEventTypes counterEventKey) {
        if (this.runCounting && this.isCounterEnabled(counterEventKey)) {
            this.countersMap.get((Object)counterEventKey).incrementCounter();
        }
    }

    public void resetCounters() {
        for (CounterEventTypes cet : this.enabledCounters) {
            this.countersMap.get((Object)cet).reset();
        }
        LOGGER.debug("StaticsCounters has been reset");
    }

    public String printStatistics() {
        StringBuilder strBuilder = new StringBuilder();
        for (CounterEventTypes cet : this.getEnabledCounters()) {
            strBuilder.append(cet.name() + ": " + this.getCountersMap().get((Object)cet).getStat() + "\n");
        }
        return strBuilder.toString();
    }

    static {
        LOGGER = LoggerFactory.getLogger(StatisticsCounters.class);
    }

    private static class LogReporterTask
    extends TimerTask {
        private static final Logger LOG = LoggerFactory.getLogger(LogReporterTask.class);
        private StatisticsCounters sc;

        public LogReporterTask(StatisticsCounters sc) {
            this.sc = sc;
        }

        @Override
        public void run() {
            for (CounterEventTypes cet : this.sc.getEnabledCounters()) {
                LOG.debug(cet.name() + ": " + this.sc.getCountersMap().get((Object)cet).getStat());
            }
        }
    }
}

