/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328;

import java.util.Objects;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.SwitchConnectionProviderModuleMXBean;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.Threads;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.Tls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.rev140328.SwitchConnectionProviderServiceInterface;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2014-03-28", name="openflow-switch-connection-provider-impl", namespace="urn:opendaylight:params:xml:ns:yang:openflow:switch:connection:provider:impl")
public abstract class AbstractSwitchConnectionProviderModule
extends AbstractModule<AbstractSwitchConnectionProviderModule>
implements SwitchConnectionProviderModuleMXBean,
SwitchConnectionProviderServiceInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSwitchConnectionProviderModule.class);
    public static final JmxAttribute portJmxAttribute = new JmxAttribute("Port");
    private Integer port;
    public static final JmxAttribute useBarrierJmxAttribute = new JmxAttribute("UseBarrier");
    private Boolean useBarrier = new Boolean("true");
    public static final JmxAttribute threadsJmxAttribute = new JmxAttribute("Threads");
    private Threads threads;
    public static final JmxAttribute switchIdleTimeoutJmxAttribute = new JmxAttribute("SwitchIdleTimeout");
    private Long switchIdleTimeout;
    public static final JmxAttribute addressJmxAttribute = new JmxAttribute("Address");
    private IpAddress address;
    public static final JmxAttribute tlsJmxAttribute = new JmxAttribute("Tls");
    private Tls tls;
    public static final JmxAttribute transportProtocolJmxAttribute = new JmxAttribute("TransportProtocol");
    private TransportProtocol transportProtocol;

    public AbstractSwitchConnectionProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractSwitchConnectionProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractSwitchConnectionProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final void resolveDependencies() {
        if (this.threads != null) {
            this.threads.injectDependencyResolver(this.dependencyResolver);
        }
        if (this.tls != null) {
            this.tls.injectDependencyResolver(this.dependencyResolver);
        }
    }

    public boolean canReuseInstance(AbstractSwitchConnectionProviderModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractSwitchConnectionProviderModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.port, other.port)) {
            return false;
        }
        if (!Objects.deepEquals(this.useBarrier, other.useBarrier)) {
            return false;
        }
        if (!Objects.deepEquals(this.threads, other.threads)) {
            return false;
        }
        if (!Objects.deepEquals(this.switchIdleTimeout, other.switchIdleTimeout)) {
            return false;
        }
        if (!Objects.deepEquals(this.address, other.address)) {
            return false;
        }
        if (!Objects.deepEquals(this.tls, other.tls)) {
            return false;
        }
        return Objects.deepEquals(this.transportProtocol, other.transportProtocol);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSwitchConnectionProviderModule that = (AbstractSwitchConnectionProviderModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Description(value="local listening port")
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public Boolean getUseBarrier() {
        return this.useBarrier;
    }

    @Override
    @Description(value="Enable barrier in Openflow java")
    public void setUseBarrier(Boolean useBarrier) {
        this.useBarrier = useBarrier;
    }

    @Override
    public Threads getThreads() {
        return this.threads;
    }

    @Override
    public void setThreads(Threads threads) {
        this.threads = threads;
    }

    @Override
    public Long getSwitchIdleTimeout() {
        return this.switchIdleTimeout;
    }

    @Override
    @Description(value="idle timeout in [ms]")
    public void setSwitchIdleTimeout(Long switchIdleTimeout) {
        this.switchIdleTimeout = switchIdleTimeout;
    }

    @Override
    public IpAddress getAddress() {
        return this.address;
    }

    @Override
    @Description(value="address of local listening interface")
    public void setAddress(IpAddress address) {
        this.address = address;
    }

    @Override
    public Tls getTls() {
        return this.tls;
    }

    @Override
    public void setTls(Tls tls) {
        this.tls = tls;
    }

    @Override
    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    @Override
    @Description(value="Transport protocol used for communication.")
    public void setTransportProtocol(TransportProtocol transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

