/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.openflowjava.protocol.api.connection.StatisticsConfiguration;
import org.opendaylight.openflowjava.protocol.spi.statistics.StatisticsHandler;
import org.opendaylight.openflowjava.statistics.StatisticsCounters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.AbstractStatisticsCollectionModule;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.Statistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.StatisticsCollectionRuntimeMXBean;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.StatisticsCollectionRuntimeRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsCollectionModule
extends AbstractStatisticsCollectionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsCollectionModule.class);

    public StatisticsCollectionModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public StatisticsCollectionModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, StatisticsCollectionModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void customValidation() {
    }

    public AutoCloseable createInstance() {
        final Statistics statistics = this.getStatistics();
        final StatisticsCounters statsCounter = StatisticsCounters.getInstance();
        StatisticsConfiguration statsConfig = null;
        if (statistics != null) {
            statsConfig = new StatisticsConfiguration(){

                public boolean getStatisticsCollect() {
                    if (statistics.getStatisticsCollect() != null) {
                        return statistics.getStatisticsCollect();
                    }
                    return false;
                }

                public int getLogReportDelay() {
                    if (statistics.getLogReportDelay() != null) {
                        return statistics.getLogReportDelay();
                    }
                    return 0;
                }
            };
        }
        if (statsConfig != null) {
            statsCounter.startCounting(statsConfig.getStatisticsCollect(), statsConfig.getLogReportDelay());
        } else {
            LOGGER.debug("Unable to start StatisticCounter - wrong configuration");
        }
        StatisticsCollectionRuntimeMXBean collectionBean = new StatisticsCollectionRuntimeMXBean(){

            @Override
            public String printOfjavaStatistics() {
                if (statsCounter != null) {
                    return statsCounter.printStatistics();
                }
                return "Statistics collection is not avaliable.";
            }

            @Override
            public String getMsgStatistics() {
                return this.printOfjavaStatistics();
            }

            @Override
            public String resetOfjavaStatistics() {
                statsCounter.resetCounters();
                return "Statistics have been reset";
            }
        };
        final StatisticsCollectionRuntimeRegistration runtimeReg = this.getRootRuntimeBeanRegistratorWrapper().register(collectionBean);
        final class AutoClosableStatisticsCollection
        implements StatisticsHandler,
        AutoCloseable {
            AutoClosableStatisticsCollection() {
            }

            @Override
            public void close() {
                if (runtimeReg != null) {
                    try {
                        runtimeReg.close();
                    }
                    catch (Exception e) {
                        String errMsg = "Error by stoping StatisticsCollectionService.";
                        LOGGER.error(errMsg, (Throwable)e);
                        throw new IllegalStateException(errMsg, e);
                    }
                }
                LOGGER.info("StatisticsCollection Service consumer (instance {} turn down.)", (Object)this);
            }

            public void resetCounters() {
                statsCounter.resetCounters();
            }

            public String printStatistics() {
                return statsCounter.printStatistics();
            }
        }
        AutoClosableStatisticsCollection ret = new AutoClosableStatisticsCollection();
        LOGGER.info("StatisticsCollection service (instance {}) initialized.", (Object)ret);
        return ret;
    }
}

