/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.modules.module.configuration.OpenflowSwitchConnectionProviderImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.modules.module.configuration.openflow._switch.connection.provider.impl.Threads;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.modules.module.configuration.openflow._switch.connection.provider.impl.Tls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OpenflowSwitchConnectionProviderImplBuilder
implements Builder<OpenflowSwitchConnectionProviderImpl> {
    private IpAddress _address;
    private Integer _port;
    private Long _switchIdleTimeout;
    private Threads _threads;
    private Tls _tls;
    private TransportProtocol _transportProtocol;
    private Boolean _useBarrier;
    Map<Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>>, Augmentation<OpenflowSwitchConnectionProviderImpl>> augmentation = Collections.emptyMap();

    public OpenflowSwitchConnectionProviderImplBuilder() {
    }

    public OpenflowSwitchConnectionProviderImplBuilder(OpenflowSwitchConnectionProviderImpl base) {
        AugmentationHolder casted;
        this._address = base.getAddress();
        this._port = base.getPort();
        this._switchIdleTimeout = base.getSwitchIdleTimeout();
        this._threads = base.getThreads();
        this._tls = base.getTls();
        this._transportProtocol = base.getTransportProtocol();
        this._useBarrier = base.isUseBarrier();
        if (base instanceof OpenflowSwitchConnectionProviderImplImpl) {
            OpenflowSwitchConnectionProviderImplImpl impl = (OpenflowSwitchConnectionProviderImplImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>>, Augmentation<OpenflowSwitchConnectionProviderImpl>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>>, Augmentation<OpenflowSwitchConnectionProviderImpl>>(casted.augmentations());
        }
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public Integer getPort() {
        return this._port;
    }

    public Long getSwitchIdleTimeout() {
        return this._switchIdleTimeout;
    }

    public Threads getThreads() {
        return this._threads;
    }

    public Tls getTls() {
        return this._tls;
    }

    public TransportProtocol getTransportProtocol() {
        return this._transportProtocol;
    }

    public Boolean isUseBarrier() {
        return this._useBarrier;
    }

    public <E extends Augmentation<OpenflowSwitchConnectionProviderImpl>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OpenflowSwitchConnectionProviderImplBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    private static void checkPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public OpenflowSwitchConnectionProviderImplBuilder setPort(Integer value) {
        if (value != null) {
            OpenflowSwitchConnectionProviderImplBuilder.checkPortRange(value);
        }
        this._port = value;
        return this;
    }

    private static void checkSwitchIdleTimeoutRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public OpenflowSwitchConnectionProviderImplBuilder setSwitchIdleTimeout(Long value) {
        if (value != null) {
            OpenflowSwitchConnectionProviderImplBuilder.checkSwitchIdleTimeoutRange(value);
        }
        this._switchIdleTimeout = value;
        return this;
    }

    public OpenflowSwitchConnectionProviderImplBuilder setThreads(Threads value) {
        this._threads = value;
        return this;
    }

    public OpenflowSwitchConnectionProviderImplBuilder setTls(Tls value) {
        this._tls = value;
        return this;
    }

    public OpenflowSwitchConnectionProviderImplBuilder setTransportProtocol(TransportProtocol value) {
        this._transportProtocol = value;
        return this;
    }

    public OpenflowSwitchConnectionProviderImplBuilder setUseBarrier(Boolean value) {
        this._useBarrier = value;
        return this;
    }

    public OpenflowSwitchConnectionProviderImplBuilder addAugmentation(Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>> augmentationType, Augmentation<OpenflowSwitchConnectionProviderImpl> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>>, Augmentation<OpenflowSwitchConnectionProviderImpl>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OpenflowSwitchConnectionProviderImplBuilder removeAugmentation(Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OpenflowSwitchConnectionProviderImpl build() {
        return new OpenflowSwitchConnectionProviderImplImpl(this);
    }

    private static final class OpenflowSwitchConnectionProviderImplImpl
    implements OpenflowSwitchConnectionProviderImpl {
        private final IpAddress _address;
        private final Integer _port;
        private final Long _switchIdleTimeout;
        private final Threads _threads;
        private final Tls _tls;
        private final TransportProtocol _transportProtocol;
        private final Boolean _useBarrier;
        private Map<Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>>, Augmentation<OpenflowSwitchConnectionProviderImpl>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OpenflowSwitchConnectionProviderImpl> getImplementedInterface() {
            return OpenflowSwitchConnectionProviderImpl.class;
        }

        private OpenflowSwitchConnectionProviderImplImpl(OpenflowSwitchConnectionProviderImplBuilder base) {
            this._address = base.getAddress();
            this._port = base.getPort();
            this._switchIdleTimeout = base.getSwitchIdleTimeout();
            this._threads = base.getThreads();
            this._tls = base.getTls();
            this._transportProtocol = base.getTransportProtocol();
            this._useBarrier = base.isUseBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>>, Augmentation<OpenflowSwitchConnectionProviderImpl>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>>, Augmentation<OpenflowSwitchConnectionProviderImpl>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public Integer getPort() {
            return this._port;
        }

        @Override
        public Long getSwitchIdleTimeout() {
            return this._switchIdleTimeout;
        }

        @Override
        public Threads getThreads() {
            return this._threads;
        }

        @Override
        public Tls getTls() {
            return this._tls;
        }

        @Override
        public TransportProtocol getTransportProtocol() {
            return this._transportProtocol;
        }

        @Override
        public Boolean isUseBarrier() {
            return this._useBarrier;
        }

        public <E extends Augmentation<OpenflowSwitchConnectionProviderImpl>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._switchIdleTimeout);
            result = 31 * result + Objects.hashCode(this._threads);
            result = 31 * result + Objects.hashCode(this._tls);
            result = 31 * result + Objects.hashCode(this._transportProtocol);
            result = 31 * result + Objects.hashCode(this._useBarrier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OpenflowSwitchConnectionProviderImpl.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OpenflowSwitchConnectionProviderImpl other = (OpenflowSwitchConnectionProviderImpl)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._switchIdleTimeout, other.getSwitchIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(this._threads, other.getThreads())) {
                return false;
            }
            if (!Objects.equals(this._tls, other.getTls())) {
                return false;
            }
            if (!Objects.equals(this._transportProtocol, other.getTransportProtocol())) {
                return false;
            }
            if (!Objects.equals(this._useBarrier, other.isUseBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OpenflowSwitchConnectionProviderImplImpl otherImpl = (OpenflowSwitchConnectionProviderImplImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OpenflowSwitchConnectionProviderImpl>>, Augmentation<OpenflowSwitchConnectionProviderImpl>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("OpenflowSwitchConnectionProviderImpl [");
            boolean first = true;
            if (this._address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_address=");
                builder.append(this._address);
            }
            if (this._port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(this._port);
            }
            if (this._switchIdleTimeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_switchIdleTimeout=");
                builder.append(this._switchIdleTimeout);
            }
            if (this._threads != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_threads=");
                builder.append(this._threads);
            }
            if (this._tls != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tls=");
                builder.append(this._tls);
            }
            if (this._transportProtocol != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_transportProtocol=");
                builder.append(this._transportProtocol);
            }
            if (this._useBarrier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_useBarrier=");
                builder.append(this._useBarrier);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

