/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.modules.module.configuration.statistics.collection.service.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.modules.module.configuration.statistics.collection.service.impl.Statistics;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StatisticsBuilder
implements Builder<Statistics> {
    private Integer _logReportDelay;
    private Boolean _statisticsCollect;
    Map<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>> augmentation = Collections.emptyMap();

    public StatisticsBuilder() {
    }

    public StatisticsBuilder(Statistics base) {
        AugmentationHolder casted;
        this._logReportDelay = base.getLogReportDelay();
        this._statisticsCollect = base.isStatisticsCollect();
        if (base instanceof StatisticsImpl) {
            StatisticsImpl impl = (StatisticsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>>(casted.augmentations());
        }
    }

    public Integer getLogReportDelay() {
        return this._logReportDelay;
    }

    public Boolean isStatisticsCollect() {
        return this._statisticsCollect;
    }

    public <E extends Augmentation<Statistics>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkLogReportDelayRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public StatisticsBuilder setLogReportDelay(Integer value) {
        if (value != null) {
            StatisticsBuilder.checkLogReportDelayRange(value);
        }
        this._logReportDelay = value;
        return this;
    }

    public StatisticsBuilder setStatisticsCollect(Boolean value) {
        this._statisticsCollect = value;
        return this;
    }

    public StatisticsBuilder addAugmentation(Class<? extends Augmentation<Statistics>> augmentationType, Augmentation<Statistics> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StatisticsBuilder removeAugmentation(Class<? extends Augmentation<Statistics>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Statistics build() {
        return new StatisticsImpl(this);
    }

    private static final class StatisticsImpl
    implements Statistics {
        private final Integer _logReportDelay;
        private final Boolean _statisticsCollect;
        private Map<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Statistics> getImplementedInterface() {
            return Statistics.class;
        }

        private StatisticsImpl(StatisticsBuilder base) {
            this._logReportDelay = base.getLogReportDelay();
            this._statisticsCollect = base.isStatisticsCollect();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getLogReportDelay() {
            return this._logReportDelay;
        }

        @Override
        public Boolean isStatisticsCollect() {
            return this._statisticsCollect;
        }

        public <E extends Augmentation<Statistics>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._logReportDelay);
            result = 31 * result + Objects.hashCode(this._statisticsCollect);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Statistics.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Statistics other = (Statistics)obj;
            if (!Objects.equals(this._logReportDelay, other.getLogReportDelay())) {
                return false;
            }
            if (!Objects.equals(this._statisticsCollect, other.isStatisticsCollect())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StatisticsImpl otherImpl = (StatisticsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Statistics>>, Augmentation<Statistics>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Statistics [");
            boolean first = true;
            if (this._logReportDelay != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_logReportDelay=");
                builder.append(this._logReportDelay);
            }
            if (this._statisticsCollect != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_statisticsCollect=");
                builder.append(this._statisticsCollect);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

