/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.channel.ChannelHandlerContext;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.impl.core.DelegatingInboundHandler;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageConsumer;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DelegatingInboundHandlerTest {
    @Mock
    ChannelHandlerContext mockChHndlrCtx;
    @Mock
    MessageConsumer mockMsgConsumer;
    @Mock
    DataObject mockDataObject;
    DelegatingInboundHandler dih;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.dih = new DelegatingInboundHandler(this.mockMsgConsumer);
    }

    @Test
    public void testChannelReadSuccess() {
        this.dih.channelRead(this.mockChHndlrCtx, (Object)this.mockDataObject);
        ((MessageConsumer)Mockito.verify((Object)this.mockMsgConsumer, (VerificationMode)Mockito.times((int)1))).consume(this.mockDataObject);
    }

    @Test
    public void testChannelInactive() {
        this.dih.channelInactive(this.mockChHndlrCtx);
        ((MessageConsumer)Mockito.verify((Object)this.mockMsgConsumer, (VerificationMode)Mockito.times((int)1))).consume((DataObject)Matchers.any(DataObject.class));
    }

    @Test
    public void testChannelUnregistered() {
        this.dih.channelUnregistered(this.mockChHndlrCtx);
        ((MessageConsumer)Mockito.verify((Object)this.mockMsgConsumer, (VerificationMode)Mockito.times((int)1))).consume((DataObject)Matchers.any(DataObject.class));
    }
}

