/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.impl.core.IdleHandler;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SwitchIdleEvent;

public class IdleHandlerTest {
    @Mock
    ChannelHandlerContext mockChHndlrCtx;
    IdleHandler idleHandler;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.idleHandler = new IdleHandler(60L, TimeUnit.MINUTES);
    }

    @Test
    public void testChannelRead() {
        try {
            this.idleHandler.channelRead(this.mockChHndlrCtx, new Object());
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((ChannelHandlerContext)Mockito.verify((Object)this.mockChHndlrCtx, (VerificationMode)Mockito.times((int)1))).fireChannelRead(Matchers.any(SwitchIdleEvent.class));
    }

    @Test
    public void testReadTimedOut() {
        try {
            this.idleHandler.readTimedOut(this.mockChHndlrCtx);
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((ChannelHandlerContext)Mockito.verify((Object)this.mockChHndlrCtx, (VerificationMode)Mockito.times((int)1))).fireChannelRead(Matchers.any(SwitchIdleEvent.class));
    }

    @Test
    public void testReadTimedOutNoOpNotFirst() {
        try {
            this.idleHandler.readTimedOut(this.mockChHndlrCtx);
            this.idleHandler.readTimedOut(this.mockChHndlrCtx);
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((ChannelHandlerContext)Mockito.verify((Object)this.mockChHndlrCtx, (VerificationMode)Mockito.times((int)1))).fireChannelRead(Matchers.any(Object.class));
    }

    @Test
    public void testReadTimedOutTwice() {
        try {
            this.idleHandler.readTimedOut(this.mockChHndlrCtx);
            ((ChannelHandlerContext)Mockito.verify((Object)this.mockChHndlrCtx, (VerificationMode)Mockito.times((int)1))).fireChannelRead(Matchers.any(Object.class));
            this.idleHandler.channelRead(this.mockChHndlrCtx, (Object)new String());
            ((ChannelHandlerContext)Mockito.verify((Object)this.mockChHndlrCtx, (VerificationMode)Mockito.times((int)2))).fireChannelRead(Matchers.any(Object.class));
            this.idleHandler.readTimedOut(this.mockChHndlrCtx);
            ((ChannelHandlerContext)Mockito.verify((Object)this.mockChHndlrCtx, (VerificationMode)Mockito.times((int)3))).fireChannelRead(Matchers.any(Object.class));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

