/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.impl.core.OFDatagramPacketEncoder;
import org.opendaylight.openflowjava.protocol.impl.core.connection.UdpMessageListenerWrapper;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInputBuilder;

public class OFDatagramPacketEncoderTest {
    @Mock
    ChannelHandlerContext ctx;
    @Mock
    GenericFutureListener<Future<Void>> listener;
    @Mock
    SerializationFactory factory;
    private UdpMessageListenerWrapper wrapper;
    private InetSocketAddress address = new InetSocketAddress("10.0.0.1", 6653);
    private List<Object> out;

    public void startUp(Short version) {
        MockitoAnnotations.initMocks((Object)this);
        this.out = new ArrayList<Object>();
        HelloInputBuilder builder = new HelloInputBuilder();
        builder.setVersion(version);
        HelloInput hello = builder.build();
        this.wrapper = new UdpMessageListenerWrapper((Object)hello, this.listener, this.address);
    }

    @Test
    public void testCorrectEncode() {
        this.startUp((short)4);
        OFDatagramPacketEncoder encoder = new OFDatagramPacketEncoder();
        encoder.setSerializationFactory(this.factory);
        try {
            encoder.encode(this.ctx, this.wrapper, this.out);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testIncorrectEncode() {
        this.startUp(null);
        OFDatagramPacketEncoder encoder = new OFDatagramPacketEncoder();
        encoder.setSerializationFactory(this.factory);
        try {
            encoder.encode(this.ctx, this.wrapper, this.out);
        }
        catch (Exception e) {
            ((UdpMessageListenerWrapper)Mockito.verify((Object)this.wrapper, (VerificationMode)Mockito.times((int)1))).getListener();
            Assert.assertEquals((String)"List should be empty", (long)0L, (long)this.out.size());
        }
    }
}

