/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.impl.core.OFDatagramPacketHandler;
import org.opendaylight.openflowjava.protocol.impl.core.UdpConnectionMap;
import org.opendaylight.openflowjava.protocol.impl.core.VersionMessageUdpWrapper;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageConsumer;
import org.opendaylight.openflowjava.util.ByteBufUtils;

public class OFDatagramPacketHandlerTest {
    @Mock
    ChannelHandlerContext ctxMock;
    @Mock
    SwitchConnectionHandler switchConnHandler;
    @Mock
    MessageConsumer consumerMock;
    @Mock
    Channel channelMock;

    @Before
    public void startUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctxMock.channel()).thenReturn((Object)this.channelMock);
    }

    @Test
    public void test() {
        OFDatagramPacketHandler handler = new OFDatagramPacketHandler(this.switchConnHandler);
        int version = 4;
        ByteBuf messageBuffer = ByteBufUtils.hexStringToByteBuf((String)"04 02 00 08 01 02 03 04");
        InetSocketAddress recipientISA = InetSocketAddress.createUnresolved("localhost", 9876);
        InetSocketAddress senderISA = InetSocketAddress.createUnresolved("192.168.15.24", 21021);
        DatagramPacket datagramPacket = new DatagramPacket(messageBuffer, recipientISA, senderISA);
        UdpConnectionMap.addConnection((InetSocketAddress)((InetSocketAddress)datagramPacket.sender()), (MessageConsumer)this.consumerMock);
        ArrayList outList = new ArrayList();
        try {
            handler.decode(this.ctxMock, datagramPacket, outList);
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong - Unexcepted exception occurred");
        }
        VersionMessageUdpWrapper versionUdpWrapper = (VersionMessageUdpWrapper)outList.get(0);
        Assert.assertEquals((String)"Wrong - incorrect version has been decoded", (long)version, (long)versionUdpWrapper.getVersion());
        Assert.assertEquals((String)"Wrong - sender addresses are different", (Object)senderISA, (Object)versionUdpWrapper.getAddress());
        messageBuffer.readerIndex(1);
        Assert.assertEquals((String)"Wrong - undecoded part of input ByteBuff is differnt to output", (long)0L, (long)messageBuffer.compareTo(versionUdpWrapper.getMessageBuffer()));
    }
}

