/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.impl.core.OFDecoder;
import org.opendaylight.openflowjava.protocol.impl.core.VersionMessageWrapper;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.statistics.CounterEventTypes;
import org.opendaylight.openflowjava.statistics.StatisticsCounters;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OFDecoderStatisticsTest {
    @Mock
    ChannelHandlerContext mockChHndlrCtx;
    @Mock
    DeserializationFactory mockDeserializationFactory;
    @Mock
    DataObject mockDataObject;
    private OFDecoder ofDecoder;
    private ByteBuf writeObj;
    private VersionMessageWrapper inMsg;
    private List<Object> outList;
    private StatisticsCounters statCounters;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.ofDecoder = new OFDecoder();
        this.ofDecoder.setDeserializationFactory(this.mockDeserializationFactory);
        this.outList = new ArrayList<Object>();
        this.statCounters = StatisticsCounters.getInstance();
        this.statCounters.startCounting(false, 0);
    }

    @After
    public void tierDown() {
        this.statCounters.stopCounting();
    }

    @Test
    public void testDecodeSuccesfullCounter() {
        if (!this.statCounters.isCounterEnabled(CounterEventTypes.US_DECODE_SUCCESS)) {
            Assert.fail((String)("Counter " + CounterEventTypes.US_DECODE_SUCCESS + " is not enable"));
        }
        if (!this.statCounters.isCounterEnabled(CounterEventTypes.US_DECODE_FAIL)) {
            Assert.fail((String)("Counter " + CounterEventTypes.US_DECODE_FAIL + " is not enable"));
        }
        if (!this.statCounters.isCounterEnabled(CounterEventTypes.US_RECEIVED_IN_OFJAVA)) {
            Assert.fail((String)("Counter " + CounterEventTypes.US_RECEIVED_IN_OFJAVA + " is not enable"));
        }
        int count = 4;
        Mockito.when((Object)this.mockDeserializationFactory.deserialize((ByteBuf)Matchers.any(ByteBuf.class), Matchers.anyShort())).thenReturn((Object)this.mockDataObject);
        try {
            for (int i = 0; i < count; ++i) {
                this.writeObj = ByteBufUtils.hexStringToByteBuf((String)"16 03 01 00");
                this.inMsg = new VersionMessageWrapper(8, this.writeObj);
                this.ofDecoder.decode(this.mockChHndlrCtx, this.inMsg, this.outList);
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((String)"Wrong - bad counter value for OFEncoder encode succesfully ", (long)count, (long)this.statCounters.getCounter(CounterEventTypes.US_DECODE_SUCCESS).getCounterValue());
        Assert.assertEquals((String)"Wrong - different between RECEIVED_IN_OFJAVA and (US_DECODE_SUCCESS + US_DECODE_FAIL)", (long)this.statCounters.getCounter(CounterEventTypes.US_RECEIVED_IN_OFJAVA).getCounterValue(), (long)(this.statCounters.getCounter(CounterEventTypes.US_DECODE_SUCCESS).getCounterValue() + this.statCounters.getCounter(CounterEventTypes.US_DECODE_FAIL).getCounterValue()));
    }

    @Test
    public void testDecodeFailCounter() {
        if (!this.statCounters.isCounterEnabled(CounterEventTypes.US_DECODE_SUCCESS)) {
            Assert.fail((String)("Counter " + CounterEventTypes.US_DECODE_SUCCESS + " is not enable"));
        }
        if (!this.statCounters.isCounterEnabled(CounterEventTypes.US_DECODE_FAIL)) {
            Assert.fail((String)("Counter " + CounterEventTypes.US_DECODE_FAIL + " is not enable"));
        }
        if (!this.statCounters.isCounterEnabled(CounterEventTypes.US_RECEIVED_IN_OFJAVA)) {
            Assert.fail((String)("Counter " + CounterEventTypes.US_RECEIVED_IN_OFJAVA + " is not enable"));
        }
        int count = 2;
        Mockito.when((Object)this.mockDeserializationFactory.deserialize((ByteBuf)Matchers.any(ByteBuf.class), Matchers.anyShort())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        try {
            for (int i = 0; i < count; ++i) {
                this.writeObj = ByteBufUtils.hexStringToByteBuf((String)"16 03 01 00");
                this.inMsg = new VersionMessageWrapper(8, this.writeObj);
                this.ofDecoder.decode(this.mockChHndlrCtx, this.inMsg, this.outList);
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((String)"Wrong - bad counter value for OFEncoder encode succesfully ", (long)count, (long)this.statCounters.getCounter(CounterEventTypes.US_DECODE_FAIL).getCounterValue());
        Assert.assertEquals((String)"Wrong - different between RECEIVED_IN_OFJAVA and (US_DECODE_SUCCESS + US_DECODE_FAIL)", (long)this.statCounters.getCounter(CounterEventTypes.US_RECEIVED_IN_OFJAVA).getCounterValue(), (long)(this.statCounters.getCounter(CounterEventTypes.US_DECODE_SUCCESS).getCounterValue() + this.statCounters.getCounter(CounterEventTypes.US_DECODE_FAIL).getCounterValue()));
    }
}

