/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.impl.core.OFDecoder;
import org.opendaylight.openflowjava.protocol.impl.core.VersionMessageWrapper;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OFDecoderTest {
    @Mock
    ChannelHandlerContext mockChHndlrCtx;
    @Mock
    DeserializationFactory mockDeserializationFactory;
    @Mock
    DataObject mockDataObject;
    OFDecoder ofDecoder;
    private ByteBuf writeObj;
    private VersionMessageWrapper inMsg;
    private List<Object> outList;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.ofDecoder = new OFDecoder();
        this.ofDecoder.setDeserializationFactory(this.mockDeserializationFactory);
        this.writeObj = ByteBufUtils.hexStringToByteBuf((String)"16 03 01 00");
        this.inMsg = new VersionMessageWrapper(8, this.writeObj);
        this.outList = new ArrayList<Object>();
    }

    @Test
    public void testDecode() {
        Mockito.when((Object)this.mockDeserializationFactory.deserialize((ByteBuf)Matchers.any(ByteBuf.class), Matchers.anyShort())).thenReturn((Object)this.mockDataObject);
        try {
            this.ofDecoder.decode(this.mockChHndlrCtx, this.inMsg, this.outList);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((Object)this.mockDataObject, (Object)this.outList.get(0));
        Assert.assertEquals((long)0L, (long)this.writeObj.refCnt());
    }

    @Test
    public void testDecodeDeserializeException() {
        Mockito.when((Object)this.mockDeserializationFactory.deserialize((ByteBuf)Matchers.any(ByteBuf.class), Matchers.anyShort())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        try {
            this.ofDecoder.decode(this.mockChHndlrCtx, this.inMsg, this.outList);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)0L, (long)this.outList.size());
        Assert.assertEquals((long)0L, (long)this.writeObj.refCnt());
    }

    @Test
    public void testDecodeDeserializeNull() {
        Mockito.when((Object)this.mockDeserializationFactory.deserialize((ByteBuf)Matchers.any(ByteBuf.class), Matchers.anyShort())).thenReturn(null);
        try {
            this.ofDecoder.decode(this.mockChHndlrCtx, this.inMsg, this.outList);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)0L, (long)this.outList.size());
        Assert.assertEquals((long)0L, (long)this.writeObj.refCnt());
    }
}

