/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.impl.core.OFEncoder;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageListenerWrapper;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.openflowjava.statistics.CounterEventTypes;
import org.opendaylight.openflowjava.statistics.StatisticsCounters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OFEncoderStatisticsTest {
    @Mock
    ChannelHandlerContext mockChHndlrCtx;
    @Mock
    SerializationFactory mockSerializationFactory;
    @Mock
    MessageListenerWrapper wrapper;
    @Mock
    OfHeader mockMsg;
    @Mock
    ByteBuf mockOut;
    @Mock
    Future<Void> future;
    @Mock
    GenericFutureListener<Future<Void>> listener;
    @Mock
    FlowModInput mockFlowModInput;
    private StatisticsCounters statCounters;
    private OFEncoder ofEncoder;

    @Before
    public void initTlest() {
        MockitoAnnotations.initMocks((Object)this);
        this.ofEncoder = new OFEncoder();
        this.ofEncoder.setSerializationFactory(this.mockSerializationFactory);
        this.statCounters = StatisticsCounters.getInstance();
        this.statCounters.startCounting(false, 0);
    }

    @After
    public void tierDown() {
        this.statCounters.stopCounting();
    }

    @Test
    public void testEncodeSuccessCounter() {
        CounterEventTypes cet = CounterEventTypes.DS_ENCODE_SUCCESS;
        if (!this.statCounters.isCounterEnabled(cet)) {
            Assert.fail((String)("Counter " + cet + " is not enabled."));
        }
        int count = 4;
        Mockito.when((Object)this.mockOut.readableBytes()).thenReturn((Object)1);
        Mockito.when((Object)this.wrapper.getMsg()).thenReturn((Object)this.mockMsg);
        Mockito.when((Object)this.wrapper.getMsg().getVersion()).thenReturn((Object)4);
        try {
            for (int i = 0; i < count; ++i) {
                this.ofEncoder.encode(this.mockChHndlrCtx, this.wrapper, this.mockOut);
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((String)"Wrong - bad counter value for OFEncoder encode succesfully ", (long)count, (long)this.statCounters.getCounter(cet).getCounterValue());
    }

    @Test
    public void testFlowModSentCounter() {
        CounterEventTypes cet = CounterEventTypes.DS_FLOW_MODS_SENT;
        if (!this.statCounters.isCounterEnabled(cet)) {
            Assert.fail((String)("Counter " + cet + " is not enabled."));
        }
        int count = 4;
        Mockito.when((Object)this.mockOut.readableBytes()).thenReturn((Object)1);
        Mockito.when((Object)this.wrapper.getMsg()).thenReturn((Object)this.mockFlowModInput);
        Mockito.when((Object)this.wrapper.getMsg().getVersion()).thenReturn((Object)4);
        try {
            for (int i = 0; i < count; ++i) {
                this.ofEncoder.encode(this.mockChHndlrCtx, this.wrapper, this.mockOut);
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((String)"Wrong - bad counter value for OFEncoder flow-mod sent", (long)count, (long)this.statCounters.getCounter(cet).getCounterValue());
    }

    @Test
    public void testEncodeEncodeFailCounter() {
        CounterEventTypes cet = CounterEventTypes.DS_ENCODE_FAIL;
        if (!this.statCounters.isCounterEnabled(cet)) {
            Assert.fail((String)("Counter " + cet + " is not enabled."));
        }
        int count = 2;
        Mockito.when((Object)this.wrapper.getMsg()).thenReturn((Object)this.mockMsg);
        Mockito.when((Object)this.wrapper.getListener()).thenReturn(this.listener);
        Mockito.when((Object)this.wrapper.getMsg().getVersion()).thenReturn((Object)4);
        ((SerializationFactory)Mockito.doThrow((Throwable)new IllegalArgumentException()).when((Object)this.mockSerializationFactory)).messageToBuffer(Matchers.anyShort(), (ByteBuf)Matchers.any(ByteBuf.class), (DataObject)Matchers.any(DataObject.class));
        try {
            for (int i = 0; i < count; ++i) {
                this.ofEncoder.encode(this.mockChHndlrCtx, this.wrapper, this.mockOut);
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((String)"Wrong - bad counter value for OFEncoder fail encode", (long)count, (long)this.statCounters.getCounter(cet).getCounterValue());
    }
}

