/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.impl.core.OFEncoder;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageListenerWrapper;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OFEncoderTest {
    @Mock
    ChannelHandlerContext mockChHndlrCtx;
    @Mock
    SerializationFactory mockSerializationFactory;
    @Mock
    MessageListenerWrapper wrapper;
    @Mock
    OfHeader mockMsg;
    @Mock
    ByteBuf mockOut;
    @Mock
    Future<Void> future;
    @Mock
    GenericFutureListener<Future<Void>> listener;
    OFEncoder ofEncoder = new OFEncoder();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.ofEncoder = new OFEncoder();
        this.ofEncoder.setSerializationFactory(this.mockSerializationFactory);
    }

    @Test
    public void testEncodeSuccess() {
        Mockito.when((Object)this.mockOut.readableBytes()).thenReturn((Object)1);
        Mockito.when((Object)this.wrapper.getMsg()).thenReturn((Object)this.mockMsg);
        Mockito.when((Object)this.wrapper.getMsg().getVersion()).thenReturn((Object)4);
        try {
            this.ofEncoder.encode(this.mockChHndlrCtx, this.wrapper, this.mockOut);
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((ByteBuf)Mockito.verify((Object)this.mockOut, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testEncodeSerializationException() {
        Mockito.when((Object)this.wrapper.getMsg()).thenReturn((Object)this.mockMsg);
        Mockito.when((Object)this.wrapper.getListener()).thenReturn(this.listener);
        Mockito.when((Object)this.wrapper.getMsg().getVersion()).thenReturn((Object)4);
        ((SerializationFactory)Mockito.doThrow((Throwable)new IllegalArgumentException()).when((Object)this.mockSerializationFactory)).messageToBuffer(Matchers.anyShort(), (ByteBuf)Matchers.any(ByteBuf.class), (DataObject)Matchers.any(DataObject.class));
        try {
            this.ofEncoder.encode(this.mockChHndlrCtx, this.wrapper, this.mockOut);
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((ByteBuf)Mockito.verify((Object)this.mockOut, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testEncodeSerializesNoBytes() {
        Mockito.when((Object)this.mockOut.readableBytes()).thenReturn((Object)0);
        Mockito.when((Object)this.wrapper.getMsg()).thenReturn((Object)this.mockMsg);
        Mockito.when((Object)this.wrapper.getMsg().getVersion()).thenReturn((Object)4);
        try {
            this.ofEncoder.encode(this.mockChHndlrCtx, this.wrapper, this.mockOut);
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((ByteBuf)Mockito.verify((Object)this.mockOut, (VerificationMode)Mockito.times((int)0))).clear();
        ((ChannelHandlerContext)Mockito.verify((Object)this.mockChHndlrCtx, (VerificationMode)Mockito.times((int)0))).writeAndFlush((Object)this.mockOut);
        ((ByteBuf)Mockito.verify((Object)this.mockOut, (VerificationMode)Mockito.times((int)0))).retain();
    }
}

