/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.opendaylight.openflowjava.protocol.impl.core.OFFrameDecoder;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionFacade;
import org.opendaylight.openflowjava.util.ByteBufUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class OFFrameDecoderTest {
    @Mock
    ChannelHandlerContext channelHandlerContext;
    @Mock
    ConnectionFacade connectionFacade;
    private OFFrameDecoder decoder;
    private List<Object> list = new ArrayList<Object>();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.decoder = new OFFrameDecoder(this.connectionFacade, false);
        this.list.clear();
    }

    @Test
    public void testDecode8BMessage() {
        try {
            this.decoder.decode(this.channelHandlerContext, ByteBufUtils.hexStringToByteBuf((String)"04 00 00 08 00 00 00 01"), this.list);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)8L, (long)((ByteBuf)this.list.get(0)).readableBytes());
    }

    @Test
    public void testDecode16BMessage() {
        ByteBuf byteBuffer = ByteBufUtils.hexStringToByteBuf((String)"04 00 00 10 00 00 00 00 00 00 00 00 00 00 00 42");
        try {
            this.decoder.decode(this.channelHandlerContext, byteBuffer, this.list);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)16L, (long)((ByteBuf)this.list.get(0)).readableBytes());
        Assert.assertEquals((long)0L, (long)byteBuffer.readableBytes());
    }

    @Test
    public void testDecode5BIncompleteMessage() {
        ByteBuf byteBuffer = ByteBufUtils.hexStringToByteBuf((String)"04 00 00 08 00");
        try {
            this.decoder.decode(this.channelHandlerContext, byteBuffer, this.list);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((String)"List is not empty", (long)0L, (long)this.list.size());
        Assert.assertEquals((long)5L, (long)byteBuffer.readableBytes());
    }

    @Test
    public void testDecode16BIncompleteMessage() {
        ByteBuf byteBuffer = ByteBufUtils.hexStringToByteBuf((String)"04 00 00 11 00 00 00 00 00 00 00 00 00 00 00 42");
        try {
            this.decoder.decode(this.channelHandlerContext, byteBuffer, this.list);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((String)"List is not empty", (long)0L, (long)this.list.size());
        Assert.assertEquals((long)16L, (long)byteBuffer.readableBytes());
    }

    @Test
    public void testDecodeCompleteAndPartialMessage() {
        ByteBuf byteBuffer = ByteBufUtils.hexStringToByteBuf((String)"04 00 00 08 00 00 00 01 04 00 00 08 00");
        try {
            this.decoder.decode(this.channelHandlerContext, byteBuffer, this.list);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)8L, (long)((ByteBuf)this.list.get(0)).readableBytes());
        Assert.assertEquals((long)1L, (long)this.list.size());
        Assert.assertEquals((long)5L, (long)byteBuffer.readableBytes());
    }

    @Test
    public void testExceptionCaught() throws Exception {
        this.decoder.exceptionCaught(this.channelHandlerContext, new Throwable());
    }

    @Test
    public void testDecode8BMessageWithTls() {
        this.decoder = new OFFrameDecoder(this.connectionFacade, true);
        try {
            this.decoder.decode(this.channelHandlerContext, ByteBufUtils.hexStringToByteBuf((String)"04 00 00 08 00 00 00 01"), this.list);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)8L, (long)((ByteBuf)this.list.get(0)).readableBytes());
    }
}

