/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.opendaylight.openflowjava.protocol.impl.core.OFVersionDetector;
import org.opendaylight.openflowjava.protocol.impl.core.VersionMessageWrapper;
import org.opendaylight.openflowjava.util.ByteBufUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class OFVersionDetectorTest {
    @Mock
    ChannelHandlerContext channelHandlerContext;
    private OFVersionDetector detector;
    private List<Object> list = new ArrayList<Object>();

    @Before
    public void setUp() {
        this.list.clear();
        this.detector = new OFVersionDetector();
    }

    @Test
    public void testDecode13ProtocolMessage() throws Exception {
        this.detector.decode(this.channelHandlerContext, ByteBufUtils.hexStringToByteBuf((String)"04 00 00 08 00 00 00 01"), this.list);
        Assert.assertEquals((long)7L, (long)((VersionMessageWrapper)this.list.get(0)).getMessageBuffer().readableBytes());
    }

    @Test
    public void testDecode10ProtocolMessage() throws Exception {
        this.detector.decode(this.channelHandlerContext, ByteBufUtils.hexStringToByteBuf((String)"01 00 00 08 00 00 00 01"), this.list);
        Assert.assertEquals((long)7L, (long)((VersionMessageWrapper)this.list.get(0)).getMessageBuffer().readableBytes());
    }

    @Test
    public void testDecodeEmptyProtocolMessage() throws Exception {
        ByteBuf byteBuffer = ByteBufUtils.hexStringToByteBuf((String)"01 00 00 08 00 00 00 01").skipBytes(8);
        this.detector.decode(this.channelHandlerContext, byteBuffer, this.list);
        Assert.assertEquals((long)0L, (long)byteBuffer.refCnt());
    }

    @Test
    public void testDecodeNotSupportedVersionProtocolMessage() throws Exception {
        this.detector.decode(this.channelHandlerContext, ByteBufUtils.hexStringToByteBuf((String)"02 00 00 08 00 00 00 01"), this.list);
        Assert.assertEquals((String)"List is not empty", (long)0L, (long)this.list.size());
    }
}

