/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import com.google.common.collect.Lists;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.api.connection.TlsConfiguration;
import org.opendaylight.openflowjava.protocol.api.connection.TlsConfigurationImpl;
import org.opendaylight.openflowjava.protocol.impl.core.ChannelInitializerFactory;
import org.opendaylight.openflowjava.protocol.impl.core.TcpChannelInitializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.PathType;

public class PublishingChannelInitializerFactoryTest {
    TlsConfiguration tlsConfiguration;
    ChannelInitializerFactory factory;
    private final long switchIdleTimeOut = 60L;
    @Mock
    SwitchConnectionHandler switchConnectionHandler;
    @Mock
    SerializationFactory serializationFactory;
    @Mock
    DeserializationFactory deserializationFactory;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.factory = new ChannelInitializerFactory();
        this.tlsConfiguration = new TlsConfigurationImpl(KeystoreType.JKS, "/exemplary-ctlTrustStore", PathType.CLASSPATH, KeystoreType.JKS, "/exemplary-ctlKeystore", PathType.CLASSPATH, (List)Lists.newArrayList((Object[])new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256"}));
        this.factory.setDeserializationFactory(this.deserializationFactory);
        this.factory.setSerializationFactory(this.serializationFactory);
        this.factory.setSwitchConnectionHandler(this.switchConnectionHandler);
        this.factory.setSwitchIdleTimeout(60L);
        this.factory.setTlsConfig(this.tlsConfiguration);
    }

    @Test
    public void testCreatePublishingChannelInitializer() {
        TcpChannelInitializer initializer = this.factory.createPublishingChannelInitializer();
        Assert.assertNotNull((Object)initializer);
    }
}

