/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import com.google.common.collect.Lists;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.api.connection.TlsConfiguration;
import org.opendaylight.openflowjava.protocol.api.connection.TlsConfigurationImpl;
import org.opendaylight.openflowjava.protocol.impl.core.DelegatingInboundHandler;
import org.opendaylight.openflowjava.protocol.impl.core.IdleHandler;
import org.opendaylight.openflowjava.protocol.impl.core.OFDecoder;
import org.opendaylight.openflowjava.protocol.impl.core.OFEncoder;
import org.opendaylight.openflowjava.protocol.impl.core.OFFrameDecoder;
import org.opendaylight.openflowjava.protocol.impl.core.OFVersionDetector;
import org.opendaylight.openflowjava.protocol.impl.core.PipelineHandlers;
import org.opendaylight.openflowjava.protocol.impl.core.TcpChannelInitializer;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterFactory;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionFacade;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.provider.impl.rev140328.Tls;

public class PublishingChannelInitializerTest {
    @Mock
    SocketChannel mockSocketCh;
    @Mock
    ChannelPipeline mockChPipeline;
    @Mock
    SwitchConnectionHandler mockSwConnHandler;
    @Mock
    ConnectionAdapterFactory mockConnAdaptorFactory;
    @Mock
    DefaultChannelGroup mockChGrp;
    @Mock
    ConnectionFacade mockConnFacade;
    @Mock
    Tls mockTls;
    SSLEngine sslEngine;
    @Mock
    SerializationFactory mockSerializationFactory;
    @Mock
    DeserializationFactory mockDeserializationFactory;
    TlsConfiguration tlsConfiguration;
    InetSocketAddress inetSockAddr;
    TcpChannelInitializer pubChInitializer;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.pubChInitializer = new TcpChannelInitializer(this.mockChGrp, this.mockConnAdaptorFactory);
        this.pubChInitializer.setSerializationFactory(this.mockSerializationFactory);
        this.pubChInitializer.setDeserializationFactory(this.mockDeserializationFactory);
        this.pubChInitializer.setSwitchIdleTimeout(1L);
        this.pubChInitializer.getConnectionIterator();
        this.pubChInitializer.setUseBarrier(true);
        Mockito.when((Object)this.mockChGrp.size()).thenReturn((Object)1);
        this.pubChInitializer.setSwitchConnectionHandler(this.mockSwConnHandler);
        this.inetSockAddr = new InetSocketAddress(InetAddress.getLocalHost(), 8675);
        Mockito.when((Object)this.mockConnAdaptorFactory.createConnectionFacade((Channel)this.mockSocketCh, null, true)).thenReturn((Object)this.mockConnFacade);
        Mockito.when((Object)this.mockSocketCh.remoteAddress()).thenReturn((Object)this.inetSockAddr);
        Mockito.when((Object)this.mockSocketCh.localAddress()).thenReturn((Object)this.inetSockAddr);
        Mockito.when((Object)this.mockSocketCh.remoteAddress()).thenReturn((Object)this.inetSockAddr);
        Mockito.when((Object)this.mockSwConnHandler.accept((InetAddress)Matchers.eq((Object)InetAddress.getLocalHost()))).thenReturn((Object)true);
        Mockito.when((Object)this.mockSocketCh.pipeline()).thenReturn((Object)this.mockChPipeline);
        this.tlsConfiguration = new TlsConfigurationImpl(KeystoreType.JKS, "/selfSignedSwitch", PathType.CLASSPATH, KeystoreType.JKS, "/selfSignedController", PathType.CLASSPATH, (List)Lists.newArrayList((Object[])new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256"}));
    }

    @Test
    public void testinitChannelEncryptionSet() {
        this.pubChInitializer.setTlsConfiguration(this.tlsConfiguration);
        this.pubChInitializer.initChannel(this.mockSocketCh);
        this.verifyCommonHandlers();
        ((ChannelPipeline)Mockito.verify((Object)this.mockChPipeline, (VerificationMode)Mockito.times((int)1))).addLast((String)Matchers.eq((Object)PipelineHandlers.SSL_HANDLER.name()), (ChannelHandler)Matchers.any(SslHandler.class));
    }

    @Test
    public void testinitChannelEncryptionSetNullTls() {
        this.pubChInitializer.setTlsConfiguration(null);
        this.pubChInitializer.initChannel(this.mockSocketCh);
        this.verifyCommonHandlers();
        ((ChannelPipeline)Mockito.verify((Object)this.mockChPipeline, (VerificationMode)Mockito.times((int)0))).addLast((String)Matchers.eq((Object)PipelineHandlers.SSL_HANDLER.name()), (ChannelHandler)Matchers.any(SslHandler.class));
    }

    @Test
    public void testinitChannelEncryptionNotSet() {
        this.pubChInitializer.initChannel(this.mockSocketCh);
        this.verifyCommonHandlers();
    }

    @Test
    public void testinitChannelNoEncryptionAcceptFails() throws UnknownHostException {
        Mockito.when((Object)this.mockSwConnHandler.accept((InetAddress)Matchers.eq((Object)InetAddress.getLocalHost()))).thenReturn((Object)false);
        this.pubChInitializer.initChannel(this.mockSocketCh);
        ((SocketChannel)Mockito.verify((Object)this.mockSocketCh, (VerificationMode)Mockito.times((int)1))).disconnect();
        ((ChannelPipeline)Mockito.verify((Object)this.mockChPipeline, (VerificationMode)Mockito.times((int)0))).addLast((String)Matchers.any(String.class), (ChannelHandler)Matchers.any(ChannelHandler.class));
    }

    @Test
    public void testExceptionThrown() {
        ((SocketChannel)Mockito.doThrow((Throwable)new IllegalArgumentException()).when((Object)this.mockSocketCh)).pipeline();
        this.pubChInitializer.initChannel(this.mockSocketCh);
        ((SocketChannel)Mockito.verify((Object)this.mockSocketCh, (VerificationMode)Mockito.times((int)1))).close();
    }

    private void verifyCommonHandlers() {
        ((ChannelPipeline)Mockito.verify((Object)this.mockChPipeline, (VerificationMode)Mockito.times((int)1))).addLast((String)Matchers.eq((Object)PipelineHandlers.IDLE_HANDLER.name()), (ChannelHandler)Matchers.any(IdleHandler.class));
        ((ChannelPipeline)Mockito.verify((Object)this.mockChPipeline, (VerificationMode)Mockito.times((int)1))).addLast((String)Matchers.eq((Object)PipelineHandlers.OF_DECODER.name()), (ChannelHandler)Matchers.any(OFDecoder.class));
        ((ChannelPipeline)Mockito.verify((Object)this.mockChPipeline, (VerificationMode)Mockito.times((int)1))).addLast((String)Matchers.eq((Object)PipelineHandlers.OF_ENCODER.name()), (ChannelHandler)Matchers.any(OFEncoder.class));
        ((ChannelPipeline)Mockito.verify((Object)this.mockChPipeline, (VerificationMode)Mockito.times((int)1))).addLast((String)Matchers.eq((Object)PipelineHandlers.OF_FRAME_DECODER.name()), (ChannelHandler)Matchers.any(OFFrameDecoder.class));
        ((ChannelPipeline)Mockito.verify((Object)this.mockChPipeline, (VerificationMode)Mockito.times((int)1))).addLast((String)Matchers.eq((Object)PipelineHandlers.OF_VERSION_DETECTOR.name()), (ChannelHandler)Matchers.any(OFVersionDetector.class));
        ((ChannelPipeline)Mockito.verify((Object)this.mockChPipeline, (VerificationMode)Mockito.times((int)1))).addLast((String)Matchers.eq((Object)PipelineHandlers.DELEGATING_INBOUND_HANDLER.name()), (ChannelHandler)Matchers.any(DelegatingInboundHandler.class));
        Assert.assertEquals((long)1L, (long)this.pubChInitializer.size());
    }
}

