/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import com.google.common.util.concurrent.ListenableFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.unix.Errors;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.impl.core.TcpChannelInitializer;
import org.opendaylight.openflowjava.protocol.impl.core.TcpHandler;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;

public class TcpHandlerTest {
    private InetAddress serverAddress = InetAddress.getLoopbackAddress();
    @Mock
    ChannelHandlerContext mockChHndlrCtx;
    @Mock
    TcpChannelInitializer mockChannelInitializer;
    @Mock
    SwitchConnectionHandler mockSwitchConnHndler;
    @Mock
    SerializationFactory mockSerializationFactory;
    @Mock
    DeserializationFactory mockDeserializationFactory;
    TcpHandler tcpHandler;

    public TcpHandlerTest() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testRunWithNullAddress() throws IOException, InterruptedException, ExecutionException {
        this.tcpHandler = new TcpHandler(null, 0);
        this.tcpHandler.setChannelInitializer(this.mockChannelInitializer);
        Assert.assertEquals((String)"failed to start server", (Object)true, (Object)this.startupServer(false));
        Assert.assertEquals((String)"failed to connect client", (Object)true, (Object)TcpHandlerTest.clientConnection(this.tcpHandler.getPort()));
        this.shutdownServer();
    }

    @Test
    public void testRunWithNullAddressOnEpoll() throws IOException, InterruptedException, ExecutionException {
        this.tcpHandler = new TcpHandler(null, 0);
        this.tcpHandler.setChannelInitializer(this.mockChannelInitializer);
        Assert.assertEquals((String)"failed to start server", (Object)true, (Object)this.startupServer(true));
        Assert.assertEquals((String)"failed to connect client", (Object)true, (Object)TcpHandlerTest.clientConnection(this.tcpHandler.getPort()));
        this.shutdownServer();
    }

    @Test
    public void testRunWithAddress() throws IOException, InterruptedException, ExecutionException {
        this.tcpHandler = new TcpHandler(this.serverAddress, 0);
        this.tcpHandler.setChannelInitializer(this.mockChannelInitializer);
        Assert.assertEquals((String)"failed to start server", (Object)true, (Object)this.startupServer(false));
        Assert.assertEquals((String)"failed to connect client", (Object)true, (Object)TcpHandlerTest.clientConnection(this.tcpHandler.getPort()));
        this.shutdownServer();
    }

    @Test
    public void testRunWithAddressOnEpoll() throws IOException, InterruptedException, ExecutionException {
        this.tcpHandler = new TcpHandler(this.serverAddress, 0);
        this.tcpHandler.setChannelInitializer(this.mockChannelInitializer);
        Assert.assertEquals((String)"failed to start server", (Object)true, (Object)this.startupServer(true));
        Assert.assertEquals((String)"failed to connect client", (Object)true, (Object)TcpHandlerTest.clientConnection(this.tcpHandler.getPort()));
        this.shutdownServer();
    }

    @Test
    public void testRunWithEncryption() throws InterruptedException, IOException, ExecutionException {
        int serverPort = 28001;
        this.tcpHandler = new TcpHandler(this.serverAddress, serverPort);
        this.tcpHandler.setChannelInitializer(this.mockChannelInitializer);
        Assert.assertEquals((String)"failed to start server", (Object)true, (Object)this.startupServer(false));
        Assert.assertEquals((String)"wrong connection count", (long)0L, (long)this.tcpHandler.getNumberOfConnections());
        Assert.assertEquals((String)"wrong port", (long)serverPort, (long)this.tcpHandler.getPort());
        Assert.assertEquals((String)"wrong address", (Object)this.serverAddress.getHostAddress(), (Object)this.tcpHandler.getAddress());
        Assert.assertEquals((String)"failed to connect client", (Object)true, (Object)TcpHandlerTest.clientConnection(this.tcpHandler.getPort()));
        this.shutdownServer();
    }

    @Test
    public void testRunWithEncryptionOnEpoll() throws InterruptedException, IOException, ExecutionException {
        int serverPort = 28001;
        this.tcpHandler = new TcpHandler(this.serverAddress, serverPort);
        this.tcpHandler.setChannelInitializer(this.mockChannelInitializer);
        Assert.assertEquals((String)"failed to start server", (Object)true, (Object)this.startupServer(true));
        Assert.assertEquals((String)"wrong connection count", (long)0L, (long)this.tcpHandler.getNumberOfConnections());
        Assert.assertEquals((String)"wrong port", (long)serverPort, (long)this.tcpHandler.getPort());
        Assert.assertEquals((String)"wrong address", (Object)this.serverAddress.getHostAddress(), (Object)this.tcpHandler.getAddress());
        Assert.assertEquals((String)"failed to connect client", (Object)true, (Object)TcpHandlerTest.clientConnection(this.tcpHandler.getPort()));
        this.shutdownServer();
    }

    @Test
    public void testSocketAlreadyInUse() throws IOException {
        boolean exceptionThrown;
        Socket firstBinder;
        block4: {
            int serverPort = 28001;
            firstBinder = new Socket();
            exceptionThrown = false;
            try {
                firstBinder.bind(new InetSocketAddress(this.serverAddress, serverPort));
            }
            catch (Exception e) {
                Assert.fail((String)("Test precondition failed - not able to bind socket to port " + serverPort));
            }
            try {
                this.tcpHandler = new TcpHandler(this.serverAddress, serverPort);
                this.tcpHandler.setChannelInitializer(this.mockChannelInitializer);
                this.tcpHandler.initiateEventLoopGroups(null, false);
                this.tcpHandler.run();
            }
            catch (Exception e) {
                if (!(e instanceof BindException)) break block4;
                exceptionThrown = true;
            }
        }
        firstBinder.close();
        Assert.assertTrue((String)"Expected BindException has not been thrown", (exceptionThrown ? 1 : 0) != 0);
    }

    @Test
    public void testSocketAlreadyInUseOnEpoll() throws IOException {
        boolean exceptionThrown;
        Socket firstBinder;
        block4: {
            int serverPort = 28001;
            firstBinder = new Socket();
            exceptionThrown = false;
            try {
                firstBinder.bind(new InetSocketAddress(this.serverAddress, serverPort));
            }
            catch (Exception e) {
                Assert.fail((String)("Test precondition failed - not able to bind socket to port " + serverPort));
            }
            try {
                this.tcpHandler = new TcpHandler(this.serverAddress, serverPort);
                this.tcpHandler.setChannelInitializer(this.mockChannelInitializer);
                this.tcpHandler.initiateEventLoopGroups(null, true);
                this.tcpHandler.run();
            }
            catch (Exception e) {
                if (!(e instanceof BindException) && !(e instanceof Errors.NativeIoException)) break block4;
                exceptionThrown = true;
            }
        }
        firstBinder.close();
        Assert.assertTrue((String)"Expected BindException has not been thrown", (exceptionThrown ? 1 : 0) != 0);
    }

    private void shutdownServer() throws InterruptedException, ExecutionException {
        ListenableFuture shutdownRet = this.tcpHandler.shutdown();
        while (!shutdownRet.isDone()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"shutdown failed", (Object)true, (Object)shutdownRet.get());
    }

    private Boolean startupServer(boolean isEpollEnabled) throws InterruptedException, IOException, ExecutionException {
        ListenableFuture online = this.tcpHandler.getIsOnlineFuture();
        this.tcpHandler.initiateEventLoopGroups(null, isEpollEnabled);
        new Thread((Runnable)this.tcpHandler).start();
        int retry = 0;
        while (!online.isDone() && retry++ < 20) {
            Thread.sleep(100L);
        }
        return online.isDone();
    }

    private static Boolean clientConnection(int port) throws IOException {
        Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
        Boolean result = socket.isConnected();
        socket.close();
        return result;
    }
}

