/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.impl.core.UdpConnectionMap;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageConsumer;

public class UdpConnectionMapTest {
    @Mock
    MessageConsumer consumerMock;
    @Mock
    ByteBuf messageBuffer;

    @Before
    public void startUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testWithSenderAddress() {
        InetSocketAddress recipientISA = InetSocketAddress.createUnresolved("localhost", 9876);
        InetSocketAddress senderISA = InetSocketAddress.createUnresolved("192.168.15.2", 21021);
        DatagramPacket datagramPacket = new DatagramPacket(this.messageBuffer, recipientISA, senderISA);
        UdpConnectionMap.addConnection((InetSocketAddress)((InetSocketAddress)datagramPacket.sender()), (MessageConsumer)this.consumerMock);
        Assert.assertEquals((String)"Wrong - different object has been returned", (Object)this.consumerMock, (Object)UdpConnectionMap.getMessageConsumer((InetSocketAddress)((InetSocketAddress)datagramPacket.sender())));
        UdpConnectionMap.removeConnection((InetSocketAddress)((InetSocketAddress)datagramPacket.sender()));
        Assert.assertNull((String)"Wrong - object has been returned after remove key-value pair", (Object)UdpConnectionMap.getMessageConsumer((InetSocketAddress)((InetSocketAddress)datagramPacket.sender())));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithoutSenderAddressOnAdd() {
        UdpConnectionMap.addConnection(null, (MessageConsumer)this.consumerMock);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithoutSenderAddressOnGet() {
        UdpConnectionMap.getMessageConsumer(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithoutSenderAddressOnRemove() {
        UdpConnectionMap.removeConnection(null);
    }
}

