/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ChannelOutboundQueue;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageListenerWrapper;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ResponseExpectedRpcListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.RpcResponseKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoReplyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInput;

public class ChannelOutboundQueue02Test {
    private static int counter;
    private static final int RPC_RESPONSE_EXPIRATION = 1;
    private static final RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>> REMOVAL_LISTENER;
    @Mock
    EchoInput echoInput;
    @Mock
    BarrierInput barrierInput;
    @Mock
    EchoReplyInput echoReplyInput;
    @Mock
    ExperimenterInput experimenterInput;
    private ConnectionAdapterImpl adapter;
    private Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> cache;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @After
    public void tierDown() {
        if (this.adapter != null && this.adapter.isAlive()) {
            this.adapter.disconnect();
        }
    }

    @Test
    public void test01() throws Exception {
        EmbeddedChannel ec = new EmbeddedChannel(new ChannelHandler[]{new EmbededChannelHandler()});
        this.adapter = new ConnectionAdapterImpl((Channel)ec, InetSocketAddress.createUnresolved("localhost", 9876), true);
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build();
        this.adapter.setResponseCache(this.cache);
        ChannelOutboundQueue cq = (ChannelOutboundQueue)ec.pipeline().last();
        counter = 0;
        this.adapter.barrier(this.barrierInput);
        this.adapter.echo(this.echoInput);
        cq.channelInactive(ec.pipeline().lastContext());
        ec.runPendingTasks();
        Assert.assertEquals((String)"Wrong - ChannelOutboundHandlerAdapter.write was invoked on closed channel", (long)0L, (long)counter);
        cq.channelActive(ec.pipeline().lastContext());
        counter = 0;
        this.adapter.barrier(this.barrierInput);
        this.adapter.experimenter(this.experimenterInput);
        ec.runPendingTasks();
        Assert.assertEquals((String)"Wrong - ChannelOutboundHandlerAdapter.write has not been invoked on opened channel", (long)2L, (long)counter);
    }

    @Test
    public void test02() {
        ChangeWritableEmbededChannel ec = new ChangeWritableEmbededChannel((ChannelHandler)new EmbededChannelHandler());
        this.adapter = new ConnectionAdapterImpl((Channel)ec, InetSocketAddress.createUnresolved("localhost", 9876), true);
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build();
        this.adapter.setResponseCache(this.cache);
        ec.setReadOnly();
        counter = 0;
        this.adapter.barrier(this.barrierInput);
        this.adapter.echo(this.echoInput);
        ec.runPendingTasks();
        Assert.assertEquals((String)"Wrong - write to readonly channel", (long)0L, (long)counter);
        ec.setWritable();
        this.adapter.echoReply(this.echoReplyInput);
        this.adapter.echo(this.echoInput);
        ec.runPendingTasks();
        Assert.assertEquals((String)"Wrong - write to writtable channel", (long)4L, (long)counter);
    }

    static {
        REMOVAL_LISTENER = new RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>>(){

            public void onRemoval(RemovalNotification<RpcResponseKey, ResponseExpectedRpcListener<?>> notification) {
                ((ResponseExpectedRpcListener)notification.getValue()).discard();
            }
        };
    }

    private class ChangeWritableEmbededChannel
    extends EmbeddedChannel {
        private boolean isWrittable;

        public ChangeWritableEmbededChannel(ChannelHandler channelHandler) {
            super(new ChannelHandler[]{channelHandler});
            this.setReadOnly();
        }

        public boolean isWritable() {
            return this.isWrittable;
        }

        public void setWritable() {
            this.isWrittable = true;
        }

        public void setReadOnly() {
            this.isWrittable = false;
        }
    }

    private class EmbededChannelHandler
    extends ChannelOutboundHandlerAdapter {
        private EmbededChannelHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof MessageListenerWrapper) {
                counter++;
            }
        }
    }
}

