/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.MessageListenerWrapper;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ResponseExpectedRpcListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.RpcResponseKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoReplyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;

public class ConnectionAdapterImpl02Test {
    private static final int RPC_RESPONSE_EXPIRATION = 1;
    private static final RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>> REMOVAL_LISTENER = new RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>>(){

        public void onRemoval(RemovalNotification<RpcResponseKey, ResponseExpectedRpcListener<?>> notification) {
            ((ResponseExpectedRpcListener)notification.getValue()).discard();
        }
    };
    @Mock
    EchoInput echoInput;
    @Mock
    BarrierInput barrierInput;
    @Mock
    EchoReplyInput echoReplyInput;
    @Mock
    ExperimenterInput experimenterInput;
    @Mock
    FlowModInput flowModInput;
    @Mock
    GetConfigInput getConfigInput;
    @Mock
    GetFeaturesInput getFeaturesInput;
    @Mock
    GetQueueConfigInput getQueueConfigInput;
    @Mock
    GroupModInput groupModInput;
    @Mock
    HelloInput helloInput;
    @Mock
    MeterModInput meterModInput;
    @Mock
    PacketOutInput packetOutInput;
    @Mock
    MultipartRequestInput multipartRequestInput;
    @Mock
    PortModInput portModInput;
    @Mock
    RoleRequestInput roleRequestInput;
    @Mock
    SetConfigInput setConfigInput;
    @Mock
    TableModInput tableModInput;
    @Mock
    GetAsyncInput getAsyncInput;
    @Mock
    SetAsyncInput setAsyncInput;
    private ConnectionAdapterImpl adapter;
    private Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> cache;
    private OfHeader responseOfCall;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @After
    public void tierDown() {
        if (this.adapter != null && this.adapter.isAlive()) {
            this.adapter.disconnect();
        }
    }

    @Test
    public void testRcp() {
        EmbeddedChannel embChannel = new EmbeddedChannel(new ChannelHandler[]{new EmbededChannelHandler()});
        this.adapter = new ConnectionAdapterImpl((Channel)embChannel, InetSocketAddress.createUnresolved("localhost", 9876), true);
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build();
        this.adapter.setResponseCache(this.cache);
        this.adapter.barrier(this.barrierInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - barrier", (Object)this.barrierInput, (Object)this.responseOfCall);
        this.adapter.echo(this.echoInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - echo", (Object)this.echoInput, (Object)this.responseOfCall);
        this.adapter.echoReply(this.echoReplyInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - echoReply", (Object)this.echoReplyInput, (Object)this.responseOfCall);
        this.adapter.experimenter(this.experimenterInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - experimenter", (Object)this.experimenterInput, (Object)this.responseOfCall);
        this.adapter.flowMod(this.flowModInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - flowMod", (Object)this.flowModInput, (Object)this.responseOfCall);
        this.adapter.getConfig(this.getConfigInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - getConfig", (Object)this.getConfigInput, (Object)this.responseOfCall);
        this.adapter.getFeatures(this.getFeaturesInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - getFeatures", (Object)this.getFeaturesInput, (Object)this.responseOfCall);
        this.adapter.getQueueConfig(this.getQueueConfigInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - getQueueConfig", (Object)this.getQueueConfigInput, (Object)this.responseOfCall);
        this.adapter.groupMod(this.groupModInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - groupMod", (Object)this.groupModInput, (Object)this.responseOfCall);
        this.adapter.hello(this.helloInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - helloInput", (Object)this.helloInput, (Object)this.responseOfCall);
        this.adapter.meterMod(this.meterModInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - meterMod", (Object)this.meterModInput, (Object)this.responseOfCall);
        this.adapter.packetOut(this.packetOutInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - packetOut", (Object)this.packetOutInput, (Object)this.responseOfCall);
        this.adapter.multipartRequest(this.multipartRequestInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - multipartRequest", (Object)this.multipartRequestInput, (Object)this.responseOfCall);
        this.adapter.portMod(this.portModInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - portMod", (Object)this.portModInput, (Object)this.responseOfCall);
        this.adapter.roleRequest(this.roleRequestInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - roleRequest", (Object)this.roleRequestInput, (Object)this.responseOfCall);
        this.adapter.setConfig(this.setConfigInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - setConfig", (Object)this.setConfigInput, (Object)this.responseOfCall);
        this.adapter.tableMod(this.tableModInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - tableMod", (Object)this.tableModInput, (Object)this.responseOfCall);
        this.adapter.getAsync(this.getAsyncInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - getAsync", (Object)this.getAsyncInput, (Object)this.responseOfCall);
        this.adapter.setAsync(this.setAsyncInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - setAsync", (Object)this.setAsyncInput, (Object)this.responseOfCall);
        this.adapter.disconnect();
    }

    private class EmbededChannelHandler
    extends ChannelOutboundHandlerAdapter {
        private EmbededChannelHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            ConnectionAdapterImpl02Test.this.responseOfCall = null;
            if (msg instanceof MessageListenerWrapper) {
                MessageListenerWrapper listener = (MessageListenerWrapper)msg;
                OfHeader ofHeader = listener.getMsg();
                ConnectionAdapterImpl02Test.this.responseOfCall = ofHeader;
            }
        }
    }
}

