/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionReadyListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ResponseExpectedRpcListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.RpcResponseKey;
import org.opendaylight.openflowjava.statistics.CounterEventTypes;
import org.opendaylight.openflowjava.statistics.StatisticsCounters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoReplyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoRequestMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoRequestMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OpenflowProtocolListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SystemNotificationsListener;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConnectionAdapterImplStatisticsTest {
    private static final int RPC_RESPONSE_EXPIRATION = 1;
    private static final RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>> REMOVAL_LISTENER = new RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>>(){

        public void onRemoval(RemovalNotification<RpcResponseKey, ResponseExpectedRpcListener<?>> notification) {
            ((ResponseExpectedRpcListener)notification.getValue()).discard();
        }
    };
    @Mock
    SystemNotificationsListener systemListener;
    @Mock
    ConnectionReadyListener readyListener;
    @Mock
    ChannelFuture channelFuture;
    @Mock
    OpenflowProtocolListener messageListener;
    @Mock
    SocketChannel channel;
    @Mock
    ChannelPipeline pipeline;
    @Mock
    EchoInput echoInput;
    @Mock
    BarrierInput barrierInput;
    @Mock
    EchoReplyInput echoReplyInput;
    @Mock
    ExperimenterInput experimenterInput;
    @Mock
    FlowModInput flowModInput;
    @Mock
    GetConfigInput getConfigInput;
    @Mock
    GetFeaturesInput getFeaturesInput;
    @Mock
    GetQueueConfigInput getQueueConfigInput;
    @Mock
    GroupModInput groupModInput;
    @Mock
    HelloInput helloInput;
    @Mock
    MeterModInput meterModInput;
    @Mock
    PacketOutInput packetOutInput;
    @Mock
    MultipartRequestInput multipartRequestInput;
    @Mock
    PortModInput portModInput;
    @Mock
    RoleRequestInput roleRequestInput;
    @Mock
    SetConfigInput setConfigInput;
    @Mock
    TableModInput tableModInput;
    @Mock
    GetAsyncInput getAsyncInput;
    @Mock
    SetAsyncInput setAsyncInput;
    private ConnectionAdapterImpl adapter;
    private Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> cache;
    private StatisticsCounters statCounters;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.statCounters = StatisticsCounters.getInstance();
        this.statCounters.startCounting(false, 0);
    }

    @After
    public void tierDown() {
        if (this.adapter != null && this.adapter.isAlive()) {
            this.adapter.disconnect();
        }
        this.statCounters.stopCounting();
    }

    @Test
    public void testEnterOFJavaCounter() {
        if (!this.statCounters.isCounterEnabled(CounterEventTypes.DS_ENTERED_OFJAVA)) {
            Assert.fail((String)("Counter " + CounterEventTypes.DS_ENTERED_OFJAVA + " is not enabled"));
        }
        if (!this.statCounters.isCounterEnabled(CounterEventTypes.DS_FLOW_MODS_ENTERED)) {
            Assert.fail((String)("Counter " + CounterEventTypes.DS_FLOW_MODS_ENTERED + " is not enabled"));
        }
        EmbeddedChannel embChannel = new EmbeddedChannel(new ChannelHandler[]{new EmbededChannelHandler()});
        this.adapter = new ConnectionAdapterImpl((Channel)embChannel, InetSocketAddress.createUnresolved("localhost", 9876), true);
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build();
        this.adapter.setResponseCache(this.cache);
        this.adapter.barrier(this.barrierInput);
        embChannel.runPendingTasks();
        this.adapter.echo(this.echoInput);
        embChannel.runPendingTasks();
        this.adapter.echoReply(this.echoReplyInput);
        embChannel.runPendingTasks();
        this.adapter.experimenter(this.experimenterInput);
        embChannel.runPendingTasks();
        this.adapter.flowMod(this.flowModInput);
        embChannel.runPendingTasks();
        this.adapter.getConfig(this.getConfigInput);
        embChannel.runPendingTasks();
        this.adapter.getFeatures(this.getFeaturesInput);
        embChannel.runPendingTasks();
        this.adapter.getQueueConfig(this.getQueueConfigInput);
        embChannel.runPendingTasks();
        this.adapter.groupMod(this.groupModInput);
        embChannel.runPendingTasks();
        this.adapter.hello(this.helloInput);
        embChannel.runPendingTasks();
        this.adapter.meterMod(this.meterModInput);
        embChannel.runPendingTasks();
        this.adapter.packetOut(this.packetOutInput);
        embChannel.runPendingTasks();
        this.adapter.multipartRequest(this.multipartRequestInput);
        embChannel.runPendingTasks();
        this.adapter.portMod(this.portModInput);
        embChannel.runPendingTasks();
        this.adapter.roleRequest(this.roleRequestInput);
        embChannel.runPendingTasks();
        this.adapter.setConfig(this.setConfigInput);
        embChannel.runPendingTasks();
        this.adapter.tableMod(this.tableModInput);
        embChannel.runPendingTasks();
        this.adapter.getAsync(this.getAsyncInput);
        embChannel.runPendingTasks();
        this.adapter.setAsync(this.setAsyncInput);
        embChannel.runPendingTasks();
        Assert.assertEquals((String)"Wrong - bad counter value for ConnectionAdapterImpl rpc methods", (long)19L, (long)this.statCounters.getCounter(CounterEventTypes.DS_ENTERED_OFJAVA).getCounterValue());
        Assert.assertEquals((String)"Wrong - bad counter value for ConnectionAdapterImpl flow-mod entered", (long)1L, (long)this.statCounters.getCounter(CounterEventTypes.DS_FLOW_MODS_ENTERED).getCounterValue());
        this.adapter.disconnect();
    }

    @Test
    public void testMessagePassCounter() {
        if (!this.statCounters.isCounterEnabled(CounterEventTypes.US_MESSAGE_PASS)) {
            Assert.fail((String)("Counter " + CounterEventTypes.US_MESSAGE_PASS + " is not enabled"));
        }
        Mockito.when((Object)this.channel.pipeline()).thenReturn((Object)this.pipeline);
        this.adapter = new ConnectionAdapterImpl((Channel)this.channel, InetSocketAddress.createUnresolved("10.0.0.1", 6653), true);
        this.adapter.setMessageListener(this.messageListener);
        this.adapter.setSystemListener(this.systemListener);
        this.adapter.setConnectionReadyListener(this.readyListener);
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build();
        this.adapter.setResponseCache(this.cache);
        Mockito.when((Object)this.channel.disconnect()).thenReturn((Object)this.channelFuture);
        EchoRequestMessage message = new EchoRequestMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        message = new ErrorMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        message = new ExperimenterMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        message = new FlowRemovedMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        message = new HelloMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        message = new MultipartReplyMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        message = new PacketInMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        message = new PortStatusMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        message = new EchoRequestMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        Assert.assertEquals((String)"Wrong - bad counter value for ConnectionAdapterImpl consume method", (long)9L, (long)this.statCounters.getCounter(CounterEventTypes.US_MESSAGE_PASS).getCounterValue());
        this.adapter.disconnect();
    }

    private class EmbededChannelHandler
    extends ChannelOutboundHandlerAdapter {
        private EmbededChannelHandler() {
        }
    }
}

