/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionReadyListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionAdapterImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ResponseExpectedRpcListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.RpcResponseKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoRequestMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoRequestMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OpenflowProtocolListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.DisconnectEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.DisconnectEventBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SwitchIdleEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SwitchIdleEventBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SystemNotificationsListener;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConnectionAdapterImplTest {
    private static final int RPC_RESPONSE_EXPIRATION = 1;
    private static final RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>> REMOVAL_LISTENER = new RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>>(){

        public void onRemoval(RemovalNotification<RpcResponseKey, ResponseExpectedRpcListener<?>> notification) {
            ((ResponseExpectedRpcListener)notification.getValue()).discard();
        }
    };
    @Mock
    SocketChannel channel;
    @Mock
    ChannelPipeline pipeline;
    @Mock
    OpenflowProtocolListener messageListener;
    @Mock
    SystemNotificationsListener systemListener;
    @Mock
    ConnectionReadyListener readyListener;
    @Mock
    Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> mockCache;
    @Mock
    ChannelFuture channelFuture;
    private ConnectionAdapterImpl adapter;
    private Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> cache;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.channel.pipeline()).thenReturn((Object)this.pipeline);
        this.adapter = new ConnectionAdapterImpl((Channel)this.channel, InetSocketAddress.createUnresolved("10.0.0.1", 6653), true);
        this.adapter.setMessageListener(this.messageListener);
        this.adapter.setSystemListener(this.systemListener);
        this.adapter.setConnectionReadyListener(this.readyListener);
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build();
        this.adapter.setResponseCache(this.cache);
        Mockito.when((Object)this.channel.disconnect()).thenReturn((Object)this.channelFuture);
    }

    @Test
    public void testConsume() {
        EchoRequestMessage message = new EchoRequestMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        ((OpenflowProtocolListener)Mockito.verify((Object)this.messageListener, (VerificationMode)Mockito.times((int)1))).onEchoRequestMessage(message);
        message = new ErrorMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        ((OpenflowProtocolListener)Mockito.verify((Object)this.messageListener, (VerificationMode)Mockito.times((int)1))).onErrorMessage((ErrorMessage)message);
        message = new ExperimenterMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        ((OpenflowProtocolListener)Mockito.verify((Object)this.messageListener, (VerificationMode)Mockito.times((int)1))).onExperimenterMessage((ExperimenterMessage)message);
        message = new FlowRemovedMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        ((OpenflowProtocolListener)Mockito.verify((Object)this.messageListener, (VerificationMode)Mockito.times((int)1))).onFlowRemovedMessage((FlowRemovedMessage)message);
        message = new HelloMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        ((OpenflowProtocolListener)Mockito.verify((Object)this.messageListener, (VerificationMode)Mockito.times((int)1))).onHelloMessage((HelloMessage)message);
        message = new MultipartReplyMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        ((OpenflowProtocolListener)Mockito.verify((Object)this.messageListener, (VerificationMode)Mockito.times((int)1))).onMultipartReplyMessage((MultipartReplyMessage)message);
        message = new PacketInMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        ((OpenflowProtocolListener)Mockito.verify((Object)this.messageListener, (VerificationMode)Mockito.times((int)1))).onPacketInMessage((PacketInMessage)message);
        message = new PortStatusMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        ((OpenflowProtocolListener)Mockito.verify((Object)this.messageListener, (VerificationMode)Mockito.times((int)1))).onPortStatusMessage((PortStatusMessage)message);
        message = new SwitchIdleEventBuilder().build();
        this.adapter.consume((DataObject)message);
        ((SystemNotificationsListener)Mockito.verify((Object)this.systemListener, (VerificationMode)Mockito.times((int)1))).onSwitchIdleEvent((SwitchIdleEvent)message);
        message = new DisconnectEventBuilder().build();
        this.adapter.consume((DataObject)message);
        ((SystemNotificationsListener)Mockito.verify((Object)this.systemListener, (VerificationMode)Mockito.times((int)1))).onDisconnectEvent((DisconnectEvent)message);
        message = new EchoRequestMessageBuilder().build();
        this.adapter.consume((DataObject)message);
        ((OpenflowProtocolListener)Mockito.verify((Object)this.messageListener, (VerificationMode)Mockito.times((int)1))).onEchoRequestMessage(message);
    }

    @Test
    public void testConsume2() {
        this.adapter.setResponseCache(this.mockCache);
        BarrierOutputBuilder barrierBuilder = new BarrierOutputBuilder();
        barrierBuilder.setXid(Long.valueOf(42L));
        BarrierOutput barrier = barrierBuilder.build();
        this.adapter.consume((DataObject)barrier);
        ((Cache)Mockito.verify(this.mockCache, (VerificationMode)Mockito.times((int)1))).getIfPresent(Matchers.any(RpcResponseKey.class));
    }

    @Test
    public void testConsume3() {
        BarrierInputBuilder inputBuilder = new BarrierInputBuilder();
        inputBuilder.setVersion(Short.valueOf((short)4));
        inputBuilder.setXid(Long.valueOf(42L));
        BarrierInput barrierInput = inputBuilder.build();
        RpcResponseKey key = new RpcResponseKey(42L, "org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutput");
        ResponseExpectedRpcListener listener = new ResponseExpectedRpcListener((Object)barrierInput, "failure", this.mockCache, key);
        this.cache.put((Object)key, (Object)listener);
        BarrierOutputBuilder barrierBuilder = new BarrierOutputBuilder();
        barrierBuilder.setXid(Long.valueOf(42L));
        BarrierOutput barrierOutput = barrierBuilder.build();
        this.adapter.consume((DataObject)barrierOutput);
        ResponseExpectedRpcListener ifPresent = (ResponseExpectedRpcListener)this.cache.getIfPresent((Object)key);
        Assert.assertNull((String)"Listener was not discarded", (Object)ifPresent);
    }

    @Test
    public void testIsAlive() {
        int port = 9876;
        String host = "localhost";
        InetSocketAddress inetSockAddr = InetSocketAddress.createUnresolved("localhost", 9876);
        ConnectionAdapterImpl connAddapter = new ConnectionAdapterImpl((Channel)this.channel, inetSockAddr, true);
        Assert.assertEquals((String)"Wrong - diffrence between channel.isOpen() and ConnectionAdapterImpl.isAlive()", (Object)this.channel.isOpen(), (Object)connAddapter.isAlive());
        connAddapter.disconnect();
        Assert.assertFalse((String)"Wrong - ConnectionAdapterImpl can not be alive after disconnet.", (boolean)connAddapter.isAlive());
    }

    @Test(expected=IllegalStateException.class)
    public void testMissingListeners() {
        int port = 9876;
        String host = "localhost";
        InetSocketAddress inetSockAddr = InetSocketAddress.createUnresolved("localhost", 9876);
        ConnectionAdapterImpl connAddapter = new ConnectionAdapterImpl((Channel)this.channel, inetSockAddr, true);
        connAddapter.setSystemListener(null);
        connAddapter.setMessageListener(null);
        connAddapter.setConnectionReadyListener(null);
        connAddapter.checkListeners();
    }
}

