/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.util.concurrent.FutureCallback;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.opendaylight.openflowjava.protocol.impl.core.connection.OutboundQueueEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInputBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class OutboundQueueEntryTest {
    private static final Logger LOG = LoggerFactory.getLogger(OutboundQueueEntryTest.class);
    private static final short VERSION = 13;
    private static final long VALUE = 1L;
    private Integer failCounter = 0;
    @Mock
    private OfHeader ofHeader;
    @Mock
    private FutureCallback<OfHeader> futureCallback;
    private final OutboundQueueEntry outboundQueueEntry = new OutboundQueueEntry();
    private final OfHeader barrierInput = new BarrierInputBuilder().setVersion(Short.valueOf((short)13)).setXid(Long.valueOf(1L)).build();
    private final OfHeader packetOutInput = new PacketOutInputBuilder().setVersion(Short.valueOf((short)13)).setXid(Long.valueOf(1L)).build();
    private final OfHeader multipartReplyMessage = new MultipartReplyMessageBuilder().setVersion(Short.valueOf((short)13)).setXid(Long.valueOf(1L)).setFlags(new MultipartRequestFlags(Boolean.valueOf(false))).build();
    private final OfHeader flowModInput = new FlowModInputBuilder().setVersion(Short.valueOf((short)13)).setXid(Long.valueOf(1L)).build();
    private final OfHeader flowRemoved = new FlowRemovedMessageBuilder().setVersion(Short.valueOf((short)13)).setXid(Long.valueOf(1L)).build();

    @Test
    public void commit() throws Exception {
        this.outboundQueueEntry.commit(this.ofHeader, this.futureCallback);
        Assert.assertTrue((boolean)this.outboundQueueEntry.isCommitted());
        Assert.assertFalse((boolean)this.outboundQueueEntry.isCompleted());
        Assert.assertFalse((boolean)this.outboundQueueEntry.isBarrier());
    }

    @Test
    public void reset() throws Exception {
        this.outboundQueueEntry.commit(this.ofHeader, this.futureCallback);
        Assert.assertTrue((boolean)this.outboundQueueEntry.isCommitted());
        this.outboundQueueEntry.reset();
        Assert.assertFalse((boolean)this.outboundQueueEntry.isCommitted());
    }

    @Test
    public void isBarrier() throws Exception {
        this.outboundQueueEntry.commit(this.barrierInput, this.futureCallback);
        Assert.assertTrue((boolean)this.outboundQueueEntry.isBarrier());
    }

    @Test
    public void takeMessage() throws Exception {
        this.outboundQueueEntry.commit(this.packetOutInput, this.futureCallback);
        this.outboundQueueEntry.takeMessage();
        ((FutureCallback)Mockito.verify(this.futureCallback)).onSuccess(Mockito.any());
    }

    @Test
    public void complete() throws Exception {
        boolean result = this.outboundQueueEntry.complete(this.multipartReplyMessage);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)this.outboundQueueEntry.isCompleted());
    }

    @Test(expected=IllegalStateException.class)
    public void completeTwice() throws Exception {
        this.outboundQueueEntry.complete(this.multipartReplyMessage);
        this.outboundQueueEntry.complete(this.multipartReplyMessage);
    }

    @Test
    public void fail() throws Exception {
        this.outboundQueueEntry.commit(this.ofHeader, this.futureCallback);
        this.outboundQueueEntry.fail(null);
        ((FutureCallback)Mockito.verify(this.futureCallback)).onFailure((Throwable)Mockito.any());
    }

    private Integer increaseFailCounter() {
        OutboundQueueEntryTest outboundQueueEntryTest = this;
        outboundQueueEntryTest.failCounter = outboundQueueEntryTest.failCounter + 1;
        return outboundQueueEntryTest.failCounter;
    }

    @Test
    public void test() throws Exception {
        FutureCallback<OfHeader> result = new FutureCallback<OfHeader>(){

            public void onSuccess(@Nullable OfHeader ofHeader) {
                LOG.info("onSuccess: xid: {}", (Object)ofHeader.getXid());
            }

            public void onFailure(Throwable throwable) {
                LOG.info("onFailure! Error: {}", throwable);
                LOG.info("Failure called {} time", (Object)OutboundQueueEntryTest.this.increaseFailCounter());
            }
        };
        this.outboundQueueEntry.commit(this.flowModInput, null);
        this.outboundQueueEntry.fail(null);
        this.outboundQueueEntry.commit(this.flowModInput, (FutureCallback)result);
        Assert.assertTrue((boolean)this.outboundQueueEntry.isCompleted());
        Assert.assertTrue((boolean)this.outboundQueueEntry.isCommitted());
        Assert.assertFalse((boolean)this.outboundQueueEntry.hasCallback());
        Assert.assertTrue((this.failCounter == 1 ? 1 : 0) != 0);
    }
}

