/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.core.connection.AbstractRpcListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ResponseExpectedRpcListener;
import org.opendaylight.openflowjava.protocol.impl.core.connection.RpcResponseKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;

public class ResponseExpectedRpcListenerTest {
    private static final RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>> REMOVAL_LISTENER = new RemovalListener<RpcResponseKey, ResponseExpectedRpcListener<?>>(){

        public void onRemoval(RemovalNotification<RpcResponseKey, ResponseExpectedRpcListener<?>> notification) {
            ((ResponseExpectedRpcListener)notification.getValue()).discard();
        }
    };
    private static final int RPC_RESPONSE_EXPIRATION = 1;
    private final Cache<RpcResponseKey, ResponseExpectedRpcListener<?>> responseCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build();

    @Test(expected=NullPointerException.class)
    public void testCreation() {
        RpcResponseKey key = new RpcResponseKey(12345L, BarrierOutput.class.getName());
        new ResponseExpectedRpcListener((Object)"MESSAGE", "Failed to send message", null, key);
    }

    @Test(expected=NullPointerException.class)
    public void testCreation2() {
        new ResponseExpectedRpcListener((Object)"MESSAGE", "Failed to send message", this.responseCache, null);
    }

    @Test
    public void testDiscard() {
        RpcResponseKey key = new RpcResponseKey(12345L, BarrierOutput.class.getName());
        ResponseExpectedRpcListener listener = new ResponseExpectedRpcListener((Object)"MESSAGE", "Failed to send message", this.responseCache, key);
        listener.discard();
        RpcError rpcError = AbstractRpcListener.buildRpcError((String)"Failed to send message", (String)"check switch connection", (Throwable)new TimeoutException("Request timed out"));
        SettableFuture result = SettableFuture.create();
        result.set((Object)RpcResultBuilder.failed().withRpcError(rpcError).build());
        try {
            Assert.assertEquals((String)"Wrong result", (Object)((RpcError)((RpcResult)result.get()).getErrors().iterator().next()).getMessage(), (Object)((RpcError)((RpcResult)listener.getResult().get()).getErrors().iterator().next()).getMessage());
            Assert.assertEquals((String)"Wrong result", (Object)((RpcResult)result.get()).getResult(), (Object)((RpcResult)listener.getResult().get()).getResult());
            Assert.assertEquals((String)"Wrong result", (Object)((RpcResult)result.get()).isSuccessful(), (Object)((RpcResult)listener.getResult().get()).isSuccessful());
        }
        catch (InterruptedException | ExecutionException e) {
            Assert.fail((String)"Problem accessing result");
        }
    }

    @Test
    public void testCompleted() {
        RpcResponseKey key = new RpcResponseKey(12345L, BarrierOutput.class.getName());
        ResponseExpectedRpcListener listener = new ResponseExpectedRpcListener((Object)"MESSAGE", "Failed to send message", this.responseCache, key);
        BarrierInputBuilder barrierBuilder = new BarrierInputBuilder();
        BarrierInput barrierInput = barrierBuilder.build();
        listener.completed((OfHeader)barrierInput);
        SettableFuture result = SettableFuture.create();
        result.set((Object)RpcResultBuilder.success((Object)barrierInput).build());
        try {
            Assert.assertEquals((String)"Wrong result", (Object)((RpcResult)result.get()).getErrors(), (Object)((RpcResult)listener.getResult().get()).getErrors());
            Assert.assertEquals((String)"Wrong result", (Object)((RpcResult)result.get()).getResult(), (Object)((RpcResult)listener.getResult().get()).getResult());
            Assert.assertEquals((String)"Wrong result", (Object)((RpcResult)result.get()).isSuccessful(), (Object)((RpcResult)listener.getResult().get()).isSuccessful());
        }
        catch (InterruptedException | ExecutionException e) {
            Assert.fail((String)"Problem accessing result");
        }
    }

    @Test
    public void testOperationSuccessful() {
        RpcResponseKey key = new RpcResponseKey(12345L, BarrierOutput.class.getName());
        ResponseExpectedRpcListener listener = new ResponseExpectedRpcListener((Object)"MESSAGE", "Failed to send message", this.responseCache, key);
        listener.operationSuccessful();
        ResponseExpectedRpcListener present = (ResponseExpectedRpcListener)this.responseCache.getIfPresent((Object)key);
        Assert.assertEquals((Object)present, (Object)listener);
    }
}

