/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.util.concurrent.Future;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.impl.core.connection.SimpleRpcListener;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;

public class SimpleRpcListenerTest {
    @Mock
    Future<Void> future;

    @Before
    public void startUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void test() {
        SimpleRpcListener listener = new SimpleRpcListener((Object)"MESSAGE", "Failed to send message");
        Assert.assertEquals((String)"Wrong message", (Object)"MESSAGE", (Object)listener.takeMessage());
        Assert.assertEquals((String)"Wrong message", (Object)listener, (Object)listener.takeListener());
    }

    @Test
    public void testSuccessfulRpc() {
        SimpleRpcListener listener = new SimpleRpcListener((Object)"MESSAGE", "Failed to send message");
        listener.operationSuccessful();
        SettableFuture result = SettableFuture.create();
        result.set((Object)RpcResultBuilder.success((Object)null).build());
        try {
            Assert.assertEquals((String)"Wrong result", (Object)((RpcResult)result.get()).getErrors(), (Object)((RpcResult)listener.getResult().get()).getErrors());
            Assert.assertEquals((String)"Wrong result", (Object)((RpcResult)result.get()).getResult(), (Object)((RpcResult)listener.getResult().get()).getResult());
            Assert.assertEquals((String)"Wrong result", (Object)((RpcResult)result.get()).isSuccessful(), (Object)((RpcResult)listener.getResult().get()).isSuccessful());
        }
        catch (InterruptedException | ExecutionException e) {
            Assert.fail((String)"Problem accessing result");
        }
    }

    @Test
    public void testOperationComplete() {
        Mockito.when((Object)this.future.isSuccess()).thenReturn((Object)false);
        SimpleRpcListener listener = new SimpleRpcListener((Object)"MESSAGE", "Failed to send message");
        listener.operationComplete(this.future);
        ((Future)Mockito.verify(this.future, (VerificationMode)Mockito.times((int)1))).cause();
        try {
            Assert.assertEquals((String)"Wrong result", (long)1L, (long)((RpcResult)listener.getResult().get()).getErrors().size());
        }
        catch (InterruptedException | ExecutionException e) {
            Assert.fail();
        }
    }

    @Test
    public void testOperationComplete2() {
        Mockito.when((Object)this.future.isSuccess()).thenReturn((Object)true);
        SimpleRpcListener listener = new SimpleRpcListener((Object)"MESSAGE", "Failed to send message");
        listener.operationComplete(this.future);
        ((Future)Mockito.verify(this.future, (VerificationMode)Mockito.times((int)0))).cause();
        try {
            Assert.assertEquals((String)"Wrong result", (long)0L, (long)((RpcResult)listener.getResult().get()).getErrors().size());
            Assert.assertEquals((String)"Wrong result", (Object)true, (Object)((RpcResult)listener.getResult().get()).isSuccessful());
        }
        catch (InterruptedException | ExecutionException e) {
            Assert.fail();
        }
    }
}

