/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionConfiguration;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.api.connection.TlsConfiguration;
import org.opendaylight.openflowjava.protocol.api.connection.TlsConfigurationImpl;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralDeserializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.ActionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterActionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterActionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterInstructionDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterInstructionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.InstructionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.openflowjava.protocol.impl.core.ServerFacade;
import org.opendaylight.openflowjava.protocol.impl.core.SwitchConnectionProviderImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionConfigurationImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ExperimenterActionSubType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;

public class SwitchConnectionProviderImpl02Test {
    @Mock
    SwitchConnectionHandler handler;
    @Mock
    OFGeneralSerializer serializer;
    @Mock
    OFGeneralDeserializer deserializer;
    @Mock
    OFDeserializer<ErrorMessage> deserializerError;
    @Mock
    OFDeserializer<ExperimenterDataOfChoice> deserializerExpMsg;
    @Mock
    OFDeserializer<ExperimenterDataOfChoice> deserializerMultipartRplMsg;
    @Mock
    OFDeserializer<QueueProperty> deserializerQueueProperty;
    @Mock
    OFDeserializer<MeterBandExperimenterCase> deserializerMeterBandExpCase;
    @Mock
    OFSerializer<ExperimenterDataOfChoice> serializerExperimenterInput;
    @Mock
    OFSerializer<ExperimenterDataOfChoice> serializerMultipartRequestExpCase;
    @Mock
    OFSerializer<MeterBandExperimenterCase> serializerMeterBandExpCase;
    private static final int SWITCH_IDLE_TIMEOUT = 2000;
    private InetAddress startupAddress;
    private TlsConfiguration tlsConfiguration;
    private SwitchConnectionProviderImpl provider;
    private ConnectionConfigurationImpl config;

    public void startUp(TransportProtocol protocol) {
        MockitoAnnotations.initMocks((Object)this);
        this.config = null;
        if (protocol != null) {
            this.createConfig(protocol);
        }
        this.provider = new SwitchConnectionProviderImpl();
    }

    private void createConfig(TransportProtocol protocol) {
        try {
            this.startupAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.tlsConfiguration = null;
        if (protocol.equals((Object)TransportProtocol.TLS)) {
            this.tlsConfiguration = new TlsConfigurationImpl(KeystoreType.JKS, "/selfSignedSwitch", PathType.CLASSPATH, KeystoreType.JKS, "/selfSignedController", PathType.CLASSPATH, (List)Lists.newArrayList((Object[])new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256"}));
        }
        this.config = new ConnectionConfigurationImpl(this.startupAddress, 0, this.tlsConfiguration, 2000L, true);
        this.config.setTransferProtocol(protocol);
    }

    @Test
    public void testServerFacade() {
        this.startUp(TransportProtocol.TCP);
        this.provider.setConfiguration((ConnectionConfiguration)this.config);
        ListenableFuture future = this.provider.startup();
        ServerFacade serverFacade = this.provider.getServerFacade();
        Assert.assertNotNull((String)"Wrong -- getServerFacade return null", (Object)serverFacade);
    }

    @Test(expected=IllegalStateException.class)
    public void testShutdownUnconfigured() {
        this.startUp(TransportProtocol.TCP);
        this.provider.shutdown();
    }

    @Test
    public void testUnregisterWrongKeys() {
        this.startUp(TransportProtocol.TCP);
        this.provider.setConfiguration((ConnectionConfiguration)this.config);
        ExperimenterInstructionSerializerKey testSerKey = new ExperimenterInstructionSerializerKey(1, Long.valueOf(42L));
        Assert.assertFalse((String)"Wrong -- unregisterSerializer", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)testSerKey));
        ExperimenterInstructionDeserializerKey tesDeserKey = new ExperimenterInstructionDeserializerKey(1, Long.valueOf(24L));
        Assert.assertFalse((String)"Wrong -- unregisterDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)tesDeserKey));
    }

    @Test
    public void testUnregisterExistingKeys() {
        this.startUp(TransportProtocol.TCP);
        this.provider.setConfiguration((ConnectionConfiguration)this.config);
        ExperimenterActionSerializerKey key1 = new ExperimenterActionSerializerKey(1, Long.valueOf(42L), TestSubType.class);
        this.provider.registerActionSerializer((ActionSerializerKey)key1, this.serializer);
        Assert.assertTrue((String)"Wrong -- unregister ActionSerializer", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key1));
        Assert.assertFalse((String)"Wrong -- unregister ActionSerializer by not existing key", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key1));
        ExperimenterActionDeserializerKey key2 = new ExperimenterActionDeserializerKey(1, Long.valueOf(42L));
        this.provider.registerActionDeserializer(key2, this.deserializer);
        Assert.assertTrue((String)"Wrong -- unregister ActionDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key2));
        Assert.assertFalse((String)"Wrong -- unregister ActionDeserializer by not existing key", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key2));
        ExperimenterInstructionSerializerKey key3 = new ExperimenterInstructionSerializerKey(1, Long.valueOf(42L));
        this.provider.registerInstructionSerializer((InstructionSerializerKey)key3, this.serializer);
        Assert.assertTrue((String)"Wrong -- unregister InstructionSerializer", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key3));
        Assert.assertFalse((String)"Wrong -- unregister InstructionSerializer by not existing key", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key3));
        ExperimenterInstructionDeserializerKey key4 = new ExperimenterInstructionDeserializerKey(1, Long.valueOf(42L));
        this.provider.registerInstructionDeserializer(key4, this.deserializer);
        Assert.assertTrue((String)"Wrong -- unregister InstructionDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key4));
        Assert.assertFalse((String)"Wrong -- unregister InstructionDeserializer by not existing key", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key4));
        MatchEntryDeserializerKey key5 = new MatchEntryDeserializerKey(1, 32768, 42);
        this.provider.registerMatchEntryDeserializer(key5, this.deserializer);
        Assert.assertTrue((String)"Wrong -- unregister MatchEntryDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key5));
        Assert.assertFalse((String)"Wrong -- unregister MatchEntryDeserializer by not existing key", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key5));
        ExperimenterIdDeserializerKey key6 = new ExperimenterIdDeserializerKey(1, 42L, ErrorMessage.class);
        this.provider.registerErrorDeserializer(key6, this.deserializerError);
        Assert.assertTrue((String)"Wrong -- unregister ErrorDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key6));
        Assert.assertFalse((String)"Wrong -- unregister ErrorDeserializer by not existing key", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key6));
        ExperimenterIdDeserializerKey key7 = new ExperimenterIdDeserializerKey(1, 42L, ExperimenterMessage.class);
        this.provider.registerExperimenterMessageDeserializer(key7, this.deserializerExpMsg);
        Assert.assertTrue((String)"Wrong -- unregister ExperimenterMessageDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key7));
        Assert.assertFalse((String)"Wrong -- unregister ExperimenterMessageDeserializer by not existing key", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key7));
        ExperimenterIdDeserializerKey key8 = new ExperimenterIdDeserializerKey(1, 42L, MultipartReplyMessage.class);
        this.provider.registerMultipartReplyMessageDeserializer(key8, this.deserializerMultipartRplMsg);
        Assert.assertTrue((String)"Wrong -- unregister MultipartReplyMessageDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key8));
        Assert.assertFalse((String)"Wrong -- unregister MultipartReplyMessageDeserializer by not existing key", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key8));
        ExperimenterIdDeserializerKey key9 = new ExperimenterIdDeserializerKey(1, 42L, MultipartReplyMessage.class);
        this.provider.registerMultipartReplyTFDeserializer(key9, this.deserializer);
        Assert.assertTrue((String)"Wrong -- unregister MultipartReplyTFDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key9));
        Assert.assertFalse((String)"Wrong -- unregister MultipartReplyTFDeserializer by non existing key", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key9));
        ExperimenterIdDeserializerKey key10 = new ExperimenterIdDeserializerKey(1, 42L, QueueProperty.class);
        this.provider.registerQueuePropertyDeserializer(key10, this.deserializerQueueProperty);
        Assert.assertTrue((String)"Wrong -- unregister QueuePropertyDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key10));
        Assert.assertFalse((String)"Wrong -- unregister QueuePropertyDeserializer by not existing key", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key10));
        ExperimenterIdDeserializerKey key11 = new ExperimenterIdDeserializerKey(1, 42L, MeterBandExperimenterCase.class);
        this.provider.registerMeterBandDeserializer(key11, this.deserializerMeterBandExpCase);
        Assert.assertTrue((String)"Wrong -- unregister MeterBandDeserializer", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key11));
        Assert.assertFalse((String)"Wrong -- unregister MeterBandDeserializer by not existing key", (boolean)this.provider.unregisterDeserializer((ExperimenterDeserializerKey)key11));
        ExperimenterIdSerializerKey key12 = new ExperimenterIdSerializerKey(1, 42L, ExperimenterDataOfChoice.class);
        this.provider.registerExperimenterMessageSerializer(key12, this.serializerExperimenterInput);
        Assert.assertTrue((String)"Wrong -- unregister ExperimenterMessageSerializer", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key12));
        Assert.assertFalse((String)"Wrong -- unregister ExperimenterMessageSerializer by not existing key", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key12));
        ExperimenterIdSerializerKey key13 = new ExperimenterIdSerializerKey(1, 42L, ExperimenterDataOfChoice.class);
        this.provider.registerMultipartRequestSerializer(key13, this.serializerMultipartRequestExpCase);
        Assert.assertTrue((String)"Wrong -- unregister MultipartRequestSerializer", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key13));
        Assert.assertFalse((String)"Wrong -- unregister MultipartRequestSerializer by not existing key", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key13));
        ExperimenterIdSerializerKey key14 = new ExperimenterIdSerializerKey(1, 42L, TableFeatureProperties.class);
        this.provider.registerMultipartRequestTFSerializer(key14, this.serializer);
        Assert.assertTrue((String)"Wrong -- unregister MultipartRequestTFSerializer", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key14));
        Assert.assertFalse((String)"Wrong -- unregister MultipartRequestTFSerializer by not existing key", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key14));
        ExperimenterIdSerializerKey key15 = new ExperimenterIdSerializerKey(1, 42L, MeterBandExperimenterCase.class);
        this.provider.registerMeterBandSerializer(key15, this.serializerMeterBandExpCase);
        Assert.assertTrue((String)"Wrong -- unregister MeterBandSerializer", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key15));
        Assert.assertFalse((String)"Wrong -- unregister MeterBandSerializer by not existing key", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key15));
        MatchEntrySerializerKey key16 = new MatchEntrySerializerKey(4, OpenflowBasicClass.class, InPort.class);
        this.provider.registerMatchEntrySerializer(key16, this.serializer);
        Assert.assertTrue((String)"Wrong -- unregister MatchEntrySerializer", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key16));
        Assert.assertFalse((String)"Wrong -- unregister MatchEntrySerializer by not existing key", (boolean)this.provider.unregisterSerializer((ExperimenterSerializerKey)key15));
    }

    private static class TestSubType
    extends ExperimenterActionSubType {
        private TestSubType() {
        }
    }
}

