/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionConfiguration;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.api.connection.TlsConfiguration;
import org.opendaylight.openflowjava.protocol.api.connection.TlsConfigurationImpl;
import org.opendaylight.openflowjava.protocol.impl.core.SwitchConnectionProviderImpl;
import org.opendaylight.openflowjava.protocol.impl.core.connection.ConnectionConfigurationImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.KeystoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.TransportProtocol;

public class SwitchConnectionProviderImplTest {
    @Mock
    SwitchConnectionHandler handler;
    private static final int SWITCH_IDLE_TIMEOUT = 2000;
    private static final int WAIT_TIMEOUT = 2000;
    private InetAddress startupAddress;
    private TlsConfiguration tlsConfiguration;
    private SwitchConnectionProviderImpl provider;
    private ConnectionConfigurationImpl config;

    public void startUp(TransportProtocol protocol) {
        MockitoAnnotations.initMocks((Object)this);
        this.config = null;
        if (protocol != null) {
            this.createConfig(protocol);
        }
        this.provider = new SwitchConnectionProviderImpl();
    }

    private void createConfig(TransportProtocol protocol) {
        try {
            this.startupAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.tlsConfiguration = null;
        if (protocol.equals((Object)TransportProtocol.TLS)) {
            this.tlsConfiguration = new TlsConfigurationImpl(KeystoreType.JKS, "/selfSignedSwitch", PathType.CLASSPATH, KeystoreType.JKS, "/selfSignedController", PathType.CLASSPATH, (List)Lists.newArrayList((Object[])new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256"}));
        }
        this.config = new ConnectionConfigurationImpl(this.startupAddress, 0, this.tlsConfiguration, 2000L, true);
        this.config.setTransferProtocol(protocol);
    }

    @Test
    public void testStartup1() {
        this.provider = new SwitchConnectionProviderImpl();
        ListenableFuture future = this.provider.startup();
        try {
            future.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Assert.assertEquals((String)"Wrong state", (Object)"java.lang.NullPointerException", (Object)e.getMessage());
        }
    }

    @Test
    public void testStartup2() {
        this.startUp(null);
        this.provider.setSwitchConnectionHandler(this.handler);
        ListenableFuture future = this.provider.startup();
        try {
            future.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Assert.assertEquals((String)"Wrong state", (Object)"java.lang.NullPointerException", (Object)e.getMessage());
        }
    }

    @Test
    public void testStartup3() {
        this.startUp(TransportProtocol.TCP);
        this.provider.setConfiguration((ConnectionConfiguration)this.config);
        ListenableFuture future = this.provider.startup();
        try {
            future.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Assert.assertEquals((String)"Wrong state", (Object)"java.lang.IllegalStateException: SwitchConnectionHandler is not set", (Object)e.getMessage());
        }
    }

    @Test
    public void testStartup4() {
        this.startUp(TransportProtocol.TCP);
        this.provider.setConfiguration((ConnectionConfiguration)this.config);
        this.provider.setSwitchConnectionHandler(this.handler);
        try {
            Assert.assertTrue((String)"Failed to start", (boolean)((Boolean)this.provider.startup().get(2000L, TimeUnit.MILLISECONDS)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testStartup5() {
        this.startUp(TransportProtocol.TLS);
        this.provider.setConfiguration((ConnectionConfiguration)this.config);
        this.provider.setSwitchConnectionHandler(this.handler);
        try {
            Assert.assertTrue((String)"Failed to start", (boolean)((Boolean)this.provider.startup().get(2000L, TimeUnit.MILLISECONDS)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testStartup6() {
        this.startUp(TransportProtocol.UDP);
        this.provider.setConfiguration((ConnectionConfiguration)this.config);
        this.provider.setSwitchConnectionHandler(this.handler);
        try {
            Assert.assertTrue((String)"Failed to start", (boolean)((Boolean)this.provider.startup().get(2000L, TimeUnit.MILLISECONDS)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testShutdown() {
        this.startUp(TransportProtocol.TCP);
        this.provider.setConfiguration((ConnectionConfiguration)this.config);
        this.provider.setSwitchConnectionHandler(this.handler);
        try {
            Assert.assertTrue((String)"Failed to start", (boolean)((Boolean)this.provider.startup().get(2000L, TimeUnit.MILLISECONDS)));
            Assert.assertTrue((String)"Failed to stop", (boolean)((Boolean)this.provider.shutdown().get(10000L, TimeUnit.MILLISECONDS)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
    }
}

