/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core.connection;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.openflowjava.protocol.impl.core.UdpChannelInitializer;
import org.opendaylight.openflowjava.protocol.impl.core.UdpHandler;

public class UdpHandlerTest {
    @Mock
    UdpChannelInitializer udpChannelInitializerMock;
    UdpHandler udpHandler;

    @Before
    public void startUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testWithEmptyAddress() throws InterruptedException, ExecutionException, IOException {
        this.udpHandler = new UdpHandler(null, 0);
        this.udpHandler.setChannelInitializer(this.udpChannelInitializerMock);
        Assert.assertTrue((String)"Wrong - start server", (boolean)this.startupServer(false));
        try {
            Assert.assertTrue((boolean)((Boolean)this.udpHandler.getIsOnlineFuture().get(1500L, TimeUnit.MILLISECONDS)));
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Wrong - getIsOnlineFuture timed out");
        }
        Assert.assertFalse((String)"Wrong - port has been set to zero", (this.udpHandler.getPort() == 0 ? 1 : 0) != 0);
        this.shutdownServer();
    }

    @Test
    public void testWithEmptyAddressOnEpoll() throws InterruptedException, ExecutionException, IOException {
        this.udpHandler = new UdpHandler(null, 0);
        this.udpHandler.setChannelInitializer(this.udpChannelInitializerMock);
        Assert.assertTrue((String)"Wrong - start server", (boolean)this.startupServer(true));
        try {
            Assert.assertTrue((boolean)((Boolean)this.udpHandler.getIsOnlineFuture().get(1500L, TimeUnit.MILLISECONDS)));
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Wrong - getIsOnlineFuture timed out");
        }
        Assert.assertFalse((String)"Wrong - port has been set to zero", (this.udpHandler.getPort() == 0 ? 1 : 0) != 0);
        this.shutdownServer();
    }

    @Test
    public void testWithAddressAndPort() throws InterruptedException, ExecutionException, IOException {
        int port = 9874;
        this.udpHandler = new UdpHandler(InetAddress.getLocalHost(), port);
        this.udpHandler.setChannelInitializer(this.udpChannelInitializerMock);
        Assert.assertTrue((String)"Wrong - start server", (boolean)this.startupServer(false));
        try {
            Assert.assertTrue((boolean)((Boolean)this.udpHandler.getIsOnlineFuture().get(1500L, TimeUnit.MILLISECONDS)));
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Wrong - getIsOnlineFuture timed out");
        }
        Assert.assertEquals((String)"Wrong - bad port number has been set", (long)port, (long)this.udpHandler.getPort());
        this.shutdownServer();
    }

    @Test
    public void testWithAddressAndPortOnEpoll() throws InterruptedException, ExecutionException, IOException {
        int port = 9874;
        this.udpHandler = new UdpHandler(InetAddress.getLocalHost(), port);
        this.udpHandler.setChannelInitializer(this.udpChannelInitializerMock);
        Assert.assertTrue((String)"Wrong - start server", (boolean)this.startupServer(true));
        try {
            Assert.assertTrue((boolean)((Boolean)this.udpHandler.getIsOnlineFuture().get(1500L, TimeUnit.MILLISECONDS)));
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Wrong - getIsOnlineFuture timed out");
        }
        Assert.assertEquals((String)"Wrong - bad port number has been set", (long)port, (long)this.udpHandler.getPort());
        this.shutdownServer();
    }

    private Boolean startupServer(boolean isEpollEnabled) throws InterruptedException, IOException, ExecutionException {
        ListenableFuture online = this.udpHandler.getIsOnlineFuture();
        this.udpHandler.initiateEventLoopGroups(null, isEpollEnabled);
        new Thread((Runnable)this.udpHandler).start();
        int retry = 0;
        while (!online.isDone() && retry++ < 20) {
            Thread.sleep(100L);
        }
        return online.isDone();
    }

    private void shutdownServer() throws InterruptedException, ExecutionException {
        ListenableFuture shutdownRet = this.udpHandler.shutdown();
        while (!shutdownRet.isDone()) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"Wrong - shutdown failed", (boolean)((Boolean)shutdownRet.get()));
    }
}

