/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializationFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;

public class DeserializationFactoryTest {
    @Test
    public void test() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        DeserializationFactory factory = new DeserializationFactory();
        factory.setRegistry((DeserializerRegistry)registry);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeByte(0);
        buffer.writeShort(8);
        buffer.writeInt(1234);
        factory.deserialize(buffer, (short)4);
        Assert.assertEquals((String)"Deserialization failed", (long)0L, (long)buffer.readableBytes());
    }

    @Test(expected=NullPointerException.class)
    public void testNotExistingDeserializer() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        DeserializationFactory factory = new DeserializationFactory();
        factory.setRegistry((DeserializerRegistry)registry);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeByte(0);
        buffer.writeShort(8);
        buffer.writeInt(1234);
        factory.deserialize(buffer, (short)0);
    }
}

