/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization;

import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.MatchDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;

public class DeserializerRegistryImplTest {
    private static final short OF13 = 4;
    private static final short OF10 = 1;
    private static final int EMPTY_VALUE = 0;

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterDeserializerNoArgs() {
        DeserializerRegistryImpl serReg = new DeserializerRegistryImpl();
        serReg.registerDeserializer(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterDeserializerNoKey() {
        DeserializerRegistryImpl serReg = new DeserializerRegistryImpl();
        serReg.registerDeserializer(null, (OFGeneralDeserializer)new MatchDeserializer());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterDeserializerNoDeserializer() {
        DeserializerRegistryImpl serReg = new DeserializerRegistryImpl();
        serReg.registerDeserializer(new MessageCodeKey(4, 0, Match.class), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnRegisterDeserializerNoMessageTypeKey() {
        DeserializerRegistryImpl derserReg = new DeserializerRegistryImpl();
        derserReg.init();
        derserReg.unregisterDeserializer(null);
    }

    @Test
    public void testUnRegisterDeserializer() {
        DeserializerRegistryImpl derserReg = new DeserializerRegistryImpl();
        derserReg.init();
        Assert.assertTrue((String)"Wrong - unregister serializer", (boolean)derserReg.unregisterDeserializer(new MessageCodeKey(4, 0, Match.class)));
        Assert.assertFalse((String)"Wrong - unregister serializer", (boolean)derserReg.unregisterDeserializer(new MessageCodeKey(1, 0, Match.class)));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetDeserializer() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        registry.getDeserializer(new MessageCodeKey(5000, 0, MatchV10.class));
        Assert.fail();
    }
}

