/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization;

import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.MessageTypeCodeKey;

public class MessageTypeCodeKeyTest {
    @Test
    public void testEqualsAndHashcode() {
        short msgType1 = 12;
        short msgVersion1 = 34;
        short msgType2 = 21;
        short msgVersion2 = 43;
        MessageTypeCodeKey key1 = new MessageTypeCodeKey(msgVersion1, msgType1);
        Assert.assertTrue((String)"Wrong - equals to same object", (boolean)key1.equals((Object)key1));
        Assert.assertFalse((String)"Wrong - equals to null", (boolean)key1.equals(null));
        Assert.assertFalse((String)"Wrong - equals to different class", (boolean)key1.equals(new Object()));
        MessageTypeCodeKey key2 = new MessageTypeCodeKey(msgVersion1, msgType1);
        Assert.assertTrue((String)"Wrong hashcode", (key1.hashCode() == key2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong - equals to mirror object", (boolean)key1.equals((Object)key2));
        key2 = new MessageTypeCodeKey(msgVersion2, msgType2);
        Assert.assertFalse((String)"Wrong hashcode", (key1.hashCode() == key2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Wrong - equals by msgType", (boolean)key1.equals((Object)key2));
        key2 = new MessageTypeCodeKey(msgVersion2, msgType1);
        Assert.assertFalse((String)"Wrong - equals by msgVersion", (boolean)key1.equals((Object)key2));
        Assert.assertFalse((String)"Wrong hashcode", (key1.hashCode() == key2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testGetter() {
        short msgType = 12;
        short msgVersion = 34;
        MessageTypeCodeKey key1 = new MessageTypeCodeKey(msgVersion, msgType);
        Assert.assertEquals((long)msgType, (long)key1.getMsgType());
        Assert.assertEquals((long)msgVersion, (long)key1.getMsgVersion());
    }
}

