/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.ErrorMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

@RunWith(value=MockitoJUnitRunner.class)
public class ErrorMessageFactoryTest {
    @Mock
    DeserializerRegistry registry;
    @Mock
    ErrorMessageFactory deserializer;
    private ErrorMessageFactory errorFactory;

    @Before
    public void startUp() {
        this.errorFactory = new ErrorMessageFactory();
    }

    @Test
    public void testWithoutData() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 00");
        ErrorMessage builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)0L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"HELLOFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"INCOMPATIBLE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 01 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADREQUEST", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADVERSION", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 02 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)2L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADACTION", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADTYPE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 03 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)3L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADINSTRUCTION", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWNINST", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 04 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)4L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADMATCH", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADTYPE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 05 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)5L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"FLOWMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 06 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)6L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"GROUPMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"GROUPEXISTS", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 07 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)7L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"PORTMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADPORT", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 08 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)8L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"TABLEMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADTABLE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 09 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)9L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"QUEUEOPFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADPORT", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 0A 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)10L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"SWITCHCONFIGFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADFLAGS", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 0B 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)11L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"ROLEREQUESTFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"STALE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 0C 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)12L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"METERMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 0D 00 00");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)13L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"TABLEFEATURESFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADTABLE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
    }

    @Test
    public void testWithoutData2() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 FF FF");
        ErrorMessage builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)0L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"HELLOFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 01 FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADREQUEST", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 02 FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)2L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADACTION", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 03 FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)3L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADINSTRUCTION", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 04 FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)4L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADMATCH", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 05 FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)5L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"FLOWMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 06 FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)6L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"GROUPMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 07 FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)7L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"PORTMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 08 FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)8L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"TABLEMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 09 FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)9L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"QUEUEOPFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 0A FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)10L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"SWITCHCONFIGFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 0B FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)11L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"ROLEREQUESTFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 0C FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)12L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"METERMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 0D FF FF");
        builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)13L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"TABLEFEATURESFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
    }

    @Test
    public void testWithData() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 01 00 01 02 03");
        ErrorMessage builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)0L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)1L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"HELLOFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"EPERM", (Object)builtByFactory.getCodeString());
        Assert.assertArrayEquals((String)"Wrong data", (byte[])new byte[]{0, 1, 2, 3}, (byte[])builtByFactory.getData());
    }

    @Test
    public void testWithIncorrectTypeEnum() {
        ByteBuf bb = BufferHelper.buildBuffer("00 20 00 05 00 01 02 03");
        ErrorMessage builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)32L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)5L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"UNKNOWN_TYPE", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertArrayEquals((String)"Wrong data", (byte[])new byte[]{0, 1, 2, 3}, (byte[])builtByFactory.getData());
    }

    @Test
    public void testWithIncorrectCodeEnum() {
        ByteBuf bb = BufferHelper.buildBuffer("00 03 00 10 00 01 02 03");
        ErrorMessage builtByFactory = (ErrorMessage)BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)3L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)16L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADINSTRUCTION", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertArrayEquals((String)"Wrong data", (byte[])new byte[]{0, 1, 2, 3}, (byte[])builtByFactory.getData());
    }

    @Test
    public void testExperimenterError() {
        Mockito.when((Object)this.registry.getDeserializer((MessageCodeKey)Matchers.any(MessageCodeKey.class))).thenReturn((Object)this.deserializer);
        this.errorFactory.injectDeserializerRegistry(this.registry);
        ByteBuf bb = BufferHelper.buildBuffer("FF FF 00 00 00 01");
        BufferHelper.deserialize(this.errorFactory, bb);
        ((ErrorMessageFactory)Mockito.verify((Object)this.deserializer, (VerificationMode)Mockito.times((int)1))).deserialize(bb);
    }
}

