/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.ExperimenterMessageFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;

@RunWith(value=MockitoJUnitRunner.class)
public class ExperimenterMessageFactoryTest {
    @Mock
    DeserializerRegistry registry;
    @Mock
    OFDeserializer<ExperimenterDataOfChoice> deserializer;
    @Mock
    ExperimenterDataOfChoice message;
    private ExperimenterMessageFactory factory;

    @Before
    public void startUp() {
        this.factory = new ExperimenterMessageFactory();
    }

    @Test
    public void test() {
        Mockito.when((Object)this.registry.getDeserializer((MessageCodeKey)Matchers.any(ExperimenterIdDeserializerKey.class))).thenReturn(this.deserializer);
        Mockito.when((Object)this.deserializer.deserialize((ByteBuf)Matchers.any(ByteBuf.class))).thenReturn((Object)this.message);
        ByteBuf buffer = ByteBufUtils.hexStringToByteBuf((String)"00 01 02 03 00 00 00 10 00 00 00 20");
        this.factory.injectDeserializerRegistry(this.registry);
        ExperimenterMessage deserializedMessage = this.factory.deserialize(buffer);
        Assert.assertEquals((String)"Wrong return value", (Object)this.message, (Object)deserializedMessage.getExperimenterDataOfChoice());
        Assert.assertEquals((String)"ByteBuf index moved", (long)0L, (long)buffer.readableBytes());
    }
}

