/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Capabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public class FeaturesReplyMessageFactoryTest {
    private OFDeserializer<GetFeaturesOutput> featuresFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.featuresFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(4, 6, GetFeaturesOutput.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 02 03 04 05 06 07 00 01 02 03 01 01 00 00 00 00 00 00 00 01 02 03");
        GetFeaturesOutput builtByFactory = BufferHelper.deserialize(this.featuresFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong datapathId", (long)283686952306183L, (long)builtByFactory.getDatapathId().longValue());
        Assert.assertEquals((String)"Wrong buffers", (long)66051L, (long)builtByFactory.getBuffers());
        Assert.assertEquals((String)"Wrong number of tables", (long)1L, (long)builtByFactory.getTables().shortValue());
        Assert.assertEquals((String)"Wrong auxiliaryId", (long)1L, (long)builtByFactory.getAuxiliaryId().shortValue());
        Assert.assertEquals((String)"Wrong capabilities", (Object)new Capabilities(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)builtByFactory.getCapabilities());
        Assert.assertEquals((String)"Wrong reserved", (long)66051L, (long)builtByFactory.getReserved());
    }

    @Test
    public void testCapabilities() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 02 03 04 05 06 07 00 01 02 03 01 01 00 00 00 00 01 6F 00 01 02 03");
        GetFeaturesOutput builtByFactory = BufferHelper.deserialize(this.featuresFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong capabilities", (Object)new Capabilities(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)builtByFactory.getCapabilities());
    }
}

